% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_matrix.R
\name{gprep}
\alias{gprep}
\title{Prepare genotype data for all statistical analyses}
\usage{
gprep(
  Glist = NULL,
  task = "prepare",
  study = NULL,
  fnBED = NULL,
  ldfiles = NULL,
  bedfiles = NULL,
  bimfiles = NULL,
  famfiles = NULL,
  mapfiles = NULL,
  ids = NULL,
  rsids = NULL,
  assembly = NULL,
  overwrite = FALSE,
  msize = 100,
  r2 = NULL,
  kb = NULL,
  cm = NULL,
  ncores = 1
)
}
\arguments{
\item{Glist}{A list containing information about the genotype matrix stored on disk.}

\item{task}{A character string specifying the task to perform. Possible tasks are "prepare" (default), "sparseld", "ldscores", and "geneticmap".}

\item{study}{The name of the study.}

\item{fnBED}{Path and filename of the .bed binary file used to store genotypes on disk.}

\item{ldfiles}{Path and filename of the .ld binary files used for storing the sparse LD matrix on disk.}

\item{bedfiles}{A vector of filenames for the PLINK bed-files.}

\item{bimfiles}{A vector of filenames for the PLINK bim-files.}

\item{famfiles}{A vector of filenames for the PLINK fam-files.}

\item{mapfiles}{A vector of filenames for the mapfiles.}

\item{ids}{A vector of individual identifiers used in the study.}

\item{rsids}{A vector of marker rsids used in the study.}

\item{assembly}{Character string indicating the name of the assembly.}

\item{overwrite}{A logical value; if TRUE, the binary genotype/LD file will be overwritten.}

\item{msize}{Number of markers used in the computation of sparseld.}

\item{r2}{A threshold value (more context might be beneficial, e.g., threshold for what?).}

\item{kb}{Size of the genomic region in kilobases (kb).}

\item{cm}{Size of the genomic region in centimorgans (cm).}

\item{ncores}{Number of processing cores to be used for genotype processing.}
}
\value{
Returns a list structure (Glist) with information about the genotypes.
}
\description{
All functions in qgg relies on a simple data infrastructure that takes five main input sources;
phenotype data (y), covariate data (X), genotype data (G or Glist), a genomic relationship
matrix (GRM or GRMlist) and genetic marker sets (sets).

The genotypes are stored in a matrix (n x m (individuals x markers)) in memory (G) or in a
binary file on disk (Glist).

It is only for small data sets that the genotype matrix (G) can stored in memory. For large data
sets the genotype matrix has to stored in a binary file on disk (Glist). Glist is as a list
structure that contains information about the genotypes in the binary file.

The gprep function prepares the Glist, and is required for downstream analyses of large-scale
genetic data. Typically, the Glist is prepared once, and saved as an *.Rdata-file.

The gprep function reads genotype information from binary PLINK files, and creates the Glist
object that contains general information about the genotypes such as reference alleles,
allele frequencies and missing genotypes, and construct a binary file on the disk that contains
the genotypes as allele counts of the alternative allele (memory usage = (n x m)/4 bytes).

The gprep function can also be used to prepare sparse ld matrices.
The r2 metric used is the pairwise correlation between markers (allele count alternative allele)
in a specified region of the genome. The marker genotype is allele count of the alternative allele
which is assumed to be centered and scaled.

The Glist structure is used as input parameter for a number of qgg core functions including:
1) construction of genomic relationship matrices (grm), 2) construction of sparse ld matrices,
3) estimating genomic parameters (greml), 4) single marker association analyses (glma),
5) gene set enrichment analyses (gsea), and 6) genomic prediction from genotypes
and phenotypes (gsolve) or genotypes and summary statistics (gscore).
}
\examples{

bedfiles <- system.file("extdata", "sample_chr1.bed", package = "qgg")
bimfiles <- system.file("extdata", "sample_chr1.bim", package = "qgg")
famfiles <- system.file("extdata", "sample_chr1.fam", package = "qgg")

Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles,
             famfiles=famfiles)

}
\author{
Peter Soerensen
}
