% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_pp_point.R
\name{stat_pp_point}
\alias{stat_pp_point}
\title{Probability-probability points}
\usage{
stat_pp_point(data = NULL, mapping = NULL, geom = "point",
  position = "identity", na.rm = TRUE, show.legend = NA,
  inherit.aes = TRUE, distribution = "norm", dparams = list(),
  detrend = FALSE, ...)
}
\arguments{
\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{distribution}{Character. Theoretical probability distribution function
to use. Do not provide the full distribution function name (e.g.,
\code{"dnorm"}). Instead, just provide its shortened name (e.g.,
\code{"norm"}). If you wish to provide a custom distribution, you may do so
by first creating the density, quantile, and random functions following the
standard nomenclature from the \code{stats} package (i.e., for
\code{"custom"}, create the \code{dcustom}, \code{pcustom},
\code{qcustom}, and \code{rcustom} functions).}

\item{dparams}{List of additional parameters passed on to the previously
chosen \code{distribution} function. If an empty list is provided (default)
then the distributional parameters are estimated via MLE. MLE for custom
distributions is currently not supported, so you must provide the
appropriate \code{dparams} in that case.}

\item{detrend}{Logical. Should the plot objects be detrended? If \code{TRUE},
the objects will be detrended according to the default identity P-P line.
This procedure was described by Thode (2002), and may help reducing visual
bias caused by the orthogonal distances from P-P points to the reference
line.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Draws probability-probability points.
}
\examples{
# generate random Normal data
set.seed(0)
smp <- data.frame(norm = rnorm(100))

# Normal P-P plot of Normal data
gg <- ggplot(data = smp, mapping = aes(sample = norm)) +
 stat_pp_point() +
 labs(x = "Probability Points", y = "Cumulative Probability")
gg

# Shifted Normal P-P plot of Normal data
dp <- list(mean = 1.5)
gg <- ggplot(data = smp, mapping = aes(sample = norm)) +
 stat_pp_point(dparams = dp) +
 labs(x = "Probability Points", y = "Cumulative Probability")
gg

# Normal P-P plot of mean ozone levels (airquality dataset)
dp <- list(mean = 38, sd = 27)
gg <- ggplot(data = airquality, mapping = aes(sample = Ozone)) +
	stat_pp_point(dparams = dp) +
 labs(x = "Probability Points", y = "Cumulative Probability")
gg

}
\references{
\itemize{
\item{\href{https://www.crcpress.com/Testing-For-Normality/Thode/p/book/9780824796136}{Thode,
H. (2002), Testing for Normality. CRC Press, 1st Ed.}}
}
}
