% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_geno_freq.R
\name{calc_geno_freq}
\alias{calc_geno_freq}
\title{Calculate genotype frequencies}
\usage{
calc_geno_freq(probs, by = c("individual", "marker"), omit_x = TRUE)
}
\arguments{
\item{probs}{List of arrays of genotype probabilities, as
calculated by \code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{by}{Whether to summarize by individual or marker}

\item{omit_x}{If TRUE, results are just for the autosomes. If
FALSE, results are a list of length two, containing the results
for the autosomes and those for the X chromosome.}
}
\value{
If \code{omit_x=TRUE}, the result is a matrix of genotype
frequencies; columns are genotypes and rows are either individuals
or markers.

If necessary (that is, if \code{omit_x=FALSE}, the data include the
X chromosome, and the set of genotypes on the X chromosome are
different than on the autosomes), the result is a list with two
components (for the autosomes and for the X chromosome), each being
a matrix of genotype frequencies.
}
\description{
Calculate genotype frequencies, by individual or by marker
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
p <- calc_genoprob(iron, err=0.002)

# genotype frequencies by marker
tab_g <- calc_geno_freq(p, "marker")

# allele frequencies by marker
ap <- genoprob_to_alleleprob(p)
tab_a <- calc_geno_freq(ap, "marker")

}
