% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxmarg.R
\name{maxmarg}
\alias{maxmarg}
\title{Find genotypes with maximum marginal probabilities}
\usage{
maxmarg(
  probs,
  map = NULL,
  minprob = 0.95,
  chr = NULL,
  pos = NULL,
  return_char = FALSE,
  quiet = TRUE,
  cores = 1,
  tol = 0.0000000000001
)
}
\arguments{
\item{probs}{Genotype probabilities, as calculated from
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{map}{Map of pseudomarkers in \code{probs}. Used only if \code{chr} and \code{pos} are provided.}

\item{minprob}{Minimum probability for making a call. If maximum
probability is less then this value, give \code{NA}.}

\item{chr}{If provided (along with \code{pos}), consider only the single specified position.}

\item{pos}{If provided (along with \code{chr}), consider only the single specified position.}

\item{return_char}{If TRUE, return genotype names as character strings.}

\item{quiet}{IF \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{tol}{Tolerance value; genotypes with probability that are within
\code{tol} of each other are treated as equivalent.}
}
\value{
If \code{chr} and \code{pos} are provided, a vector of
genotypes is returned. In this case, \code{map} is needed.

Otherwise, the result is a object like that returned by \code{\link[=viterbi]{viterbi()}},
A list of two-dimensional arrays of imputed genotypes,
individuals x positions. Also includes these attributes:
\itemize{
\item \code{crosstype} - The cross type of the input \code{cross}.
\item \code{is_x_chr} - Logical vector indicating whether chromosomes
are to be treated as the X chromosome or not, from input \code{cross}.
\item \code{alleles} - Vector of allele codes, from input
\code{cross}.
}
}
\description{
For each individual at each position, find the genotype with the maximum marginal probability.
}
\details{
If multiple genotypes share the maximum probability, one is chosen at random.
}
\examples{
# load data and calculate genotype probabilities
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
pr <- calc_genoprob(iron, error_prob=0.002)

# full set of imputed genotypes
ginf <- maxmarg(pr)

# imputed genotypes at a fixed position
g <- maxmarg(pr, iron$gmap, chr=8, pos=45.5)

# return genotype names rather than integers
g <- maxmarg(pr, iron$gmap, chr=8, pos=45.5, return_char=TRUE)
}
\seealso{
\code{\link[=sim_geno]{sim_geno()}}, \code{\link[=viterbi]{viterbi()}}
}
