% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sdp.R
\name{sdp2char}
\alias{sdp2char}
\title{Convert strain distribution patterns to character strings}
\usage{
sdp2char(sdp, n_strains = NULL, strains = NULL)
}
\arguments{
\item{sdp}{Vector of strain distribution patterns (integers between
1 and \eqn{2^n-2} where \eqn{n} is the number of strains.}

\item{n_strains}{Number of founder strains (if missing but
\code{strains} is provided, we use the length of \code{strains})}

\item{strains}{Vector of single-letter codes for the strains}
}
\value{
Vector of character strings with the two groups of alleles
separated by a vertical bar (|).
}
\description{
Convert a vector of numeric codes for strain distribution patterns to character strings.
}
\examples{
sdp <- c(m1=1, m2=12, m3=240)
sdp2char(sdp, 8)
sdp2char(sdp, strains=c("A", "B", "1", "D", "Z", "C", "P", "W"))
}
\seealso{
\code{\link[=invert_sdp]{invert_sdp()}}, \code{\link[=calc_sdp]{calc_sdp()}}
}
