% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst_genoprob.R
\name{fst_genoprob}
\alias{fst_genoprob}
\title{Store genotype probabilities in fst database}
\usage{
fst_genoprob(
  genoprob,
  fbase,
  fdir = ".",
  compress = 0,
  verbose = TRUE,
  overwrite = FALSE,
  quiet = !verbose
)
}
\arguments{
\item{genoprob}{Object of class \code{"calc_genoprob"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}
and \code{\link[qtl2:calc_genoprob]{qtl2::calc_genoprob()}}.}

\item{fbase}{Base of filename for fst database.}

\item{fdir}{Directory for fst database.}

\item{compress}{Amount of compression to use (value in the range 0-100; lower values mean larger file sizes)}

\item{verbose}{Opposite of \code{quiet}; deprecated argument (to be removed).}

\item{overwrite}{If FALSE (the default), refuse to overwrite any files that already exist.}

\item{quiet}{If FALSE (the default), show messages about fst database creation.}
}
\value{
A list containing the attributes of \code{genoprob}
and the address for the created fst database.
Components are:
\itemize{
\item \code{dim} - List of all dimensions of 3-D arrays.
\item \code{dimnames} - List of all dimension names of 3-D arrays.
\item \code{is_x_chr} - Vector of all is_x_chr attributes.
\item \code{chr} - Vector of (subset of) chromosome names for this object.
\item \code{ind} - Vector of (subset of) individual names for this object.
\item \code{mar} - Vector of (subset of) marker names for this object.
\item \code{fst} - Path and base of file names for the fst database.
}
}
\description{
Save an R/qtl2 genotype probabilities object to a set of fst files for fast access with reduced memory usage.
}
\details{
The genotype probabilities are stored in separate databases for each chromosome
as tables of (indivduals*genotypes) x (positions) in directory \code{fst}.
The \code{dim}, \code{dimnames} and \code{is_x_chr} elements of the object
have information about the entire fst database.
If a \code{fst_genoprob} object is a subset of another such object,
the \code{chr}, \code{ind}, and \code{mar} contain information about what is in the subset.
However, the \code{fst} databases are not altered in a subset, and can be restored by
\code{\link[=fst_restore]{fst_restore()}}. The actual elements of an \code{"fst_genoprob"}
object are only accessible to the user after a call to \code{\link[=unclass]{unclass()}}; instead
the usual access to elements of the object invoke \code{\link[=subset.fst_genoprob]{subset.fst_genoprob()}}.
}
\section{Functions}{
\itemize{
\item \code{fst_genoprob}: Deprecated version (to be deleted)
}}

\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probs <- calc_genoprob(grav2, map, error_prob=0.002)
dir <- tempdir()
fprobs <- fst_genoprob(probs, "grav2", dir, overwrite=TRUE)

# clean up: remove all the files we created
unlink(fst_files(fprobs))
}
\seealso{
\code{\link[=fst_path]{fst_path()}}, \code{\link[=fst_extract]{fst_extract()}}, \code{\link[=fst_files]{fst_files()}}, \code{\link[=replace_path]{replace_path()}}, \code{\link[=fst_restore]{fst_restore()}}
}
\keyword{utilities}
