% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_exon.R, R/ggplot_gene_exon.R
\name{gene_exon}
\alias{gene_exon}
\alias{summary.gene_exon}
\alias{subset.gene_exon}
\alias{ggplot_gene_exon}
\alias{autoplot.gene_exon}
\title{Get exons for set of genes}
\usage{
gene_exon(
  top_snps_tbl,
  feature_tbl = query_genes(chr_id, range_Mbp[1], range_Mbp[2])
)

\method{summary}{gene_exon}(object, gene_name = NULL, top_snps_tbl = NULL, extra = 0.005, ...)

\method{subset}{gene_exon}(x, gene_val, ...)

ggplot_gene_exon(
  object,
  top_snps_tbl = NULL,
  plot_now = TRUE,
  genes = unique(object$gene),
  ...
)

\method{autoplot}{gene_exon}(x, ...)
}
\arguments{
\item{top_snps_tbl}{table from \code{\link[qtl2]{top_snps}}}

\item{feature_tbl}{table of features from \code{query_genes}; see \code{\link[qtl2]{create_gene_query_func}}}

\item{object}{table of feature information from \code{query_genes}; see \code{\link[qtl2]{create_gene_query_func}}}

\item{gene_name}{name of gene as character string}

\item{extra}{extra region beyond gene for SNPs (in Mbp)}

\item{...}{arguments passed along to \code{\link{gene_exon}}}

\item{x}{Object of class \code{gene_exon}.}

\item{gene_val}{Name of gene from object \code{x}.}

\item{plot_now}{plot now if TRUE}

\item{genes}{Names of genes in \code{object}}
}
\value{
tbl of exon and gene features

tbl of summary

list of ggplots (see \code{\link{gene_exon}})
}
\description{
Match up exon start,stop,strand with genes. Use \code{query_genes} to find features; see \code{\link[qtl2]{create_gene_query_func}}.

Returns table of gene and its exons.

Uses \code{\link{gene_exon}} to plot genes, exons, mRNA with SNPs.
}
\examples{
dirpath <- "https://raw.githubusercontent.com/rqtl/qtl2data/master/DOex"

# Read DOex example cross from 'qtl2data'
DOex <- subset(qtl2::read_cross2(file.path(dirpath, "DOex.zip")), chr = "2")

\donttest{
# Download genotype probabilities
tmpfile <- tempfile()
download.file(file.path(dirpath, "DOex_genoprobs_2.rds"), tmpfile, quiet=TRUE)
pr <- readRDS(tmpfile)
unlink(tmpfile)

# Download SNP info for DOex from web and read as RDS.
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_snpinfo.rds"), tmpfile, quiet=TRUE)
snpinfo <- readRDS(tmpfile)
unlink(tmpfile)
snpinfo <- dplyr::rename(snpinfo, pos = pos_Mbp)

# Convert to SNP probabilities
snpinfo <- qtl2::index_snps(DOex$pmap, snpinfo)
snppr <- qtl2::genoprob_to_snpprob(pr, snpinfo)

# Scan SNPs.
scan_snppr <- qtl2::scan1(snppr, DOex$pheno)

# Collect top SNPs
top_snps_tbl <- top_snps_pattern(scan_snppr, snpinfo)

# Download Gene info for DOex from web via RDS
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_genes.rds"), tmpfile, quiet=TRUE)
gene_tbl <- readRDS(tmpfile)
unlink(tmpfile)

# Get Gene exon information.
out <- gene_exon(top_snps_tbl, gene_tbl)
summary(out, gene = out$gene[1])
}

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{hplot}
\keyword{utilities}
