% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_LcpFinder.R
\name{plot.LcpFinder}
\alias{plot.LcpFinder}
\alias{points.LcpFinder}
\alias{points,LcpFinder-method}
\alias{lines.LcpFinder}
\alias{lines,LcpFinder-method}
\title{Plot a \code{LcpFinder} object}
\usage{
\S4method{points}{LcpFinder}(x, add = TRUE, ...)

\S4method{lines}{LcpFinder}(x, add = TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{LcpFinder}}}

\item{add}{boolean; if \code{TRUE} (the default), the plot is added to the
existing plot. If \code{FALSE}, a new plot is created.}

\item{...}{arguments passed to the default plotting functions}
}
\value{
no return value
}
\description{
Plots a \code{\link{LcpFinder}} object.
}
\details{
\code{points()} plots points at the centroids of the cells to which
  a path has been found. \code{lines()} plots all of the LCPs found so far by
  the \code{\link{LcpFinder}} object.
}
\examples{
library(quadtree)
data(habitat)

qt <- quadtree(habitat, .1)

start_point <- c(6989, 34007)
end_point <- c(12558, 27602)
lcpf <- lcp_finder(qt, start_point)
lcp <- find_lcp(lcpf, end_point)

plot(qt, crop = TRUE, border_lwd = .3, na_col = NULL)
points(lcpf, col = "red", pch = 16, cex = .4)
lines(lcpf)
}
