% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_affinity.R
\name{textmodel_affinity}
\alias{textmodel_affinity}
\title{Class affinity maximum likelihood text scaling model}
\usage{
textmodel_affinity(
  x,
  y,
  exclude = NULL,
  smooth = 0.5,
  ref_smooth = 0.5,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{the \link{dfm} or \link{bootstrap_dfm} object on which the model
will be fit.  Does not need to contain only the training documents, since
the index of these will be matched automatically.}

\item{y}{vector of training classes/scores associated with each document
identified in \code{data}}

\item{exclude}{a set of words to exclude from the model}

\item{smooth}{a smoothing parameter for class affinities; defaults to 0.5
(Jeffreys prior). A plausible alternative would be 1.0 (Laplace prior).}

\item{ref_smooth}{a smoothing parameter for token distributions;
defaults to 0.5}

\item{verbose}{logical; if \code{TRUE} print diagnostic information during
fitting.}
}
\description{
\code{textmodel_affinity} implements the maximum likelihood supervised text
scaling method described in Perry and Benoit (2017).
}
\examples{
(af <- textmodel_affinity(data_dfm_lbgexample, y = c("L", NA, NA, NA, "R", NA)))
predict(af)
predict(af, newdata = data_dfm_lbgexample[6, ])

\dontrun{
# compute bootstrapped SEs
dfmat <- quanteda::bootstrap_dfm(data_corpus_dailnoconf1991, n = 10, remove_punct = TRUE)
textmodel_affinity(dfmat, y = c("Govt", "Opp", "Opp", rep(NA, 55)))
}
}
\references{
Perry, P.O. & Benoit, K.R. (2017). Scaling Text with
the Class Affinity Model.
\href{http://arxiv.org/abs/1710.08963}{arXiv:1710.08963 [stat.ML]}.
}
\seealso{
\code{\link[=predict.textmodel_affinity]{predict.textmodel_affinity()}} for methods of applying a
fitted \link{textmodel_affinity} model object to predict quantities from
(other) documents.
}
\author{
Patrick Perry and Kenneth Benoit
}
\keyword{experimental}
\keyword{textmodel}
