% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.max.R
\name{crossq.max}
\alias{crossq.max}
\title{Corss-Quantilogram up to a Given Lag Order}
\usage{
crossq.max(DATA, vecA, Kmax)
}
\arguments{
\item{DATA}{An input matrix}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{Kmax}{The maximum lag order (integer)}
}
\value{
A vector of cross-quantilogram
}
\description{
The cross-quantilograms from 1 to a given lag order.
}
\details{
This function calculates the partial cross-quantilograms up to the lag order
users specify.
}
\examples{
## data source 
data("sys.risk") 

## data: 2 variables 
D = sys.risk[,c("Market", "JPM")]

# probability levels for the 2 variables 
vecA = c(0.1, 0.5)

## cross-quantilogram with lags between 1 and 5
crossq.max(D, vecA, 5)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series."
\emph{Journal of Econometrics}, 193(1), 251-270.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
