% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.partial.sb.opt.R
\name{crossq.partial.sb.opt}
\alias{crossq.partial.sb.opt}
\title{Stationary Bootstrap for the Partial Cross-Quantilogram dwith the choice of the stationary-bootstrap parameter}
\usage{
crossq.partial.sb.opt(DATA, vecA, k, Bsize, sigLev)
}
\arguments{
\item{DATA}{The original data matrix}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{k}{A lag order}

\item{Bsize}{The number of repetition of bootstrap}

\item{sigLev}{The statistical significance level}
}
\value{
The boostrap critical values
}
\description{
Returns critical values for the partial cross-quantilogram, based on the stationary bootstrap with the choice of the stationary-bootstrap parameter.
}
\details{
This function generates critical values for for the partial cross-quantilogram,
using the stationary bootstrap in Politis and Romano (1994).
}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.

Patton, A., Politis, D. N., and White, H. (2009).
Correction to "Automatic block-length selection for the dependent bootstrap"
by D. Politis and H. White. \emph{Econometric Reviews}, 28(4), 372-375.

Politis, D. N., and White, H. (2004).
"Automatic block-length selection for the dependent bootstrap."
\emph{Econometric Reviews}, 23(1), 53-70.

Politis, Dimitris N., and Joseph P. Romano. (1994).
"The stationary bootstrap."
\emph{Journal of the American Statistical Association} 89.428: 1303-1313.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
