% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.sb.opt.R
\name{crossq.sb.opt}
\alias{crossq.sb.opt}
\title{Stationary Bootstrap for the Cross-Quantilogram with the choice of the stationary-bootstrap parameter}
\usage{
crossq.sb.opt(DATA, vecA, k, Bsize, sigLev)
}
\arguments{
\item{DATA}{The original data matrix}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{k}{A lag order}

\item{Bsize}{The number of repetition of bootstrap}

\item{sigLev}{The statistical significance level}
}
\value{
The boostrap critical values
}
\description{
Returns critical values for the cross-quantilogram, based on the stationary bootstrap with the choice of the stationary-bootstrap parameter.
}
\details{
This function generates critical values for for the cross-quantilogram,
using the stationary bootstrap in Politis and Romano (1994).
To choose parameter for the statioanry bootstrap, this function
first obtaines the optimal value for each time serie using the
result provided by Politis and White (2004) and Patton, Politis and White (2004)
(The R-package, "np", written by  Hayfield and Racine is used).
Next, the average of the obtained values is used as the parameter value.
}
\examples{
## data source
data("sys.risk")

## data: 2 variables
D = sys.risk[,c("Market", "JPM")]

# probability levels for the 2 variables
vecA = c(0.1, 0.5)

## setup for stationary bootstrap
Bsize  = 5    ## small size 5 for test
sigLev = 0.05 ## significance level

## cross-quantilogram with the lag of 5
crossq.sb.opt(D, vecA, 5, Bsize, sigLev)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.

Patton, A., Politis, D. N., and White, H. (2009).
Correction to "Automatic block-length selection for the dependent bootstrap"
by D. Politis and H. White. \emph{Econometric Reviews}, 28(4), 372-375.

Politis, D. N., and White, H. (2004).
"Automatic block-length selection for the dependent bootstrap."
\emph{Econometric Reviews}, 23(1), 53-70.

Politis, Dimitris N., and Joseph P. Romano. (1994).
"The stationary bootstrap."
\emph{Journal of the American Statistical Association} 89.428: 1303-1313.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
