% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{colSums_if}
\alias{colSums_if}
\title{Column Sums Conditional on Frequency of Observed Values}
\usage{
colSums_if(
  x,
  ov.min = 1,
  prop = TRUE,
  inclusive = TRUE,
  impute = TRUE,
  allNA = NA_real_
)
}
\arguments{
\item{x}{numeric or logical matrix. If not a matrix, it will be coerced to
one.}

\item{ov.min}{minimum frequency of observed values required per column. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{nrow(x)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the sum should
be calculated if the frequency of observed values in a column is exactly
equal to \code{ov.min}.}

\item{impute}{logical vector of length 1 specifying if missing values should
be imputed with the mean of observed values of \code{x[, i]}. If TRUE
(default), this will make sums over the same rows with different amounts of
observed data comparable.}

\item{allNA}{numeric vector of length 1 specifying what value should be
returned for columns that are all NA. This is most applicable when
\code{ov.min = 0} and \code{inclusive = TRUE}. The default is NA, which
differs from \code{colSums} with \code{na.rm = TRUE} where 0 is returned.
Note, the value is overwritten by NA if the frequency of observed values in
that column is less than (or equal to) that specified by \code{ov.min}.}
}
\value{
numeric vector of length = \code{ncol(x)} with names =
  \code{colnames(x)} providing the sum of each column or NA depending on the
  frequency of observed values.
}
\description{
\code{colSums_if} calculates the sum of every column in a numeric or logical
matrix conditional on the frequency of observed data. If the frequency of
observed values in that column is less than (or equal to) that specified by
\code{ov.min}, then NA is returned for that column. It also has the option to
return a value other than 0 (e.g., NA) when all columns are NA, which differs
from \code{colSums(x, na.rm = TRUE)}.
}
\details{
Conceptually this function does: \code{apply(X = x, MARGIN = 2, FUN = sum_if,
ov.min = ov.min, prop = prop, inclusive = inclusive)}. But for computational
efficiency purposes it does not because then the observed values conditioning
would not be vectorized. Instead, it uses \code{colSums} and then inserts NAs
for columns that have too few observed values.
}
\examples{
colSums_if(airquality)
colSums_if(x = airquality, ov.min = 150, prop = FALSE)
x <- data.frame("x" = c(1, 2, NA), "y" = c(1, NA, NA), "z" = c(NA, NA, NA))
colSums_if(x)
colSums_if(x, ov.min = 0)
colSums_if(x, ov.min = 0, allNA = 0)
identical(x = colSums(x, na.rm = TRUE),
   y = colSums_if(x, impute = FALSE, ov.min = 0, allNA = 0)) # identical to
   # colSums(x, na.rm = TRUE)
}
\seealso{
\code{\link{colMeans_if}}
   \code{\link{rowSums_if}}
   \code{\link{rowMeans_if}}
   \code{\link{colSums}}
}
