% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer.R
\name{integer_}
\alias{integer_}
\alias{integer_bounded}
\alias{integer_left_bounded}
\alias{integer_right_bounded}
\alias{integer_positive}
\alias{integer_negative}
\title{Integer generators}
\usage{
integer_(len = c(1L, 10L), any_na = FALSE, big_int = FALSE)

integer_bounded(left, right, len = c(1L, 10L), any_na = FALSE)

integer_left_bounded(left, len = c(1L, 10L), any_na = FALSE, big_int = FALSE)

integer_right_bounded(right, len = c(1L, 10L), any_na = FALSE, big_int = FALSE)

integer_positive(len = c(1L, 10L), any_na = FALSE, big_int = FALSE)

integer_negative(len = c(1L, 10L), any_na = FALSE, big_int = FALSE)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}

\item{big_int}{Should integers near the maximum size be
included? This may cause problems because if the result
of a computation results in an integer larger than the
maximum it will be silently coerced it to a double.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
A set of generators for integer vectors.
}
\examples{
integer_() \%>\% show_example()
integer_(big_int = TRUE) \%>\% show_example()
integer_bounded(left = -5L, right = 5L) \%>\% show_example()
integer_(len = 10L, any_na = TRUE) \%>\% show_example()
}
