% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{pgp_to_pss}
\alias{pgp_to_pss}
\title{Map PGP identifiers to PSS identifiers}
\usage{
pgp_to_pss(
  pgp_id = NULL,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{pgp_id}{A character vector of PGS Catalog Publication identifiers,
e.g., "PGP000001". If \code{NULL} then returns results for all PGP
identifiers in the Catalog.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if
any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A data frame of two columns: \code{pgp_id} and \code{pss_id}.
}
\description{
Map PGP identifiers to PSS identifiers.
}
\examples{
\dontrun{
pgp_to_pss('PGP000001')
pgp_to_pss(c('PGP000017', 'PGP000042'))
}
}
