% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{n}
\alias{n}
\alias{n,scores-method}
\alias{n,publications-method}
\alias{n,traits-method}
\alias{n,performance_metrics-method}
\alias{n,sample_sets-method}
\alias{n,cohorts-method}
\alias{n,trait_categories-method}
\alias{n,releases-method}
\title{Number of PGS Catalog entities}
\usage{
n(x, unique = FALSE)

\S4method{n}{scores}(x, unique = FALSE)

\S4method{n}{publications}(x, unique = FALSE)

\S4method{n}{traits}(x, unique = FALSE)

\S4method{n}{performance_metrics}(x, unique = FALSE)

\S4method{n}{sample_sets}(x, unique = FALSE)

\S4method{n}{cohorts}(x, unique = FALSE)

\S4method{n}{trait_categories}(x, unique = FALSE)

\S4method{n}{releases}(x, unique = FALSE)
}
\arguments{
\item{x}{A \linkS4class{scores}, \linkS4class{publications},
\linkS4class{traits}, \linkS4class{performance_metrics},
\linkS4class{sample_sets}, \linkS4class{cohorts},
\linkS4class{trait_categories} or \linkS4class{releases} object.}

\item{unique}{Whether to count only unique entries (\code{TRUE}) or not
(\code{FALSE}).}
}
\value{
An integer scalar.
}
\description{
This function returns the number of entities in a PGS Catalog object. To
avoid ambiguity with \code{dplyr::n()} use \code{quincunx::n()}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Return the number of polygenic scores in a scores object:
my_scores <- get_scores(pgs_id = c('PGS000007', 'PGS000007', 'PGS000042'))
n(my_scores)

# If you want to count unique scores only, then use the `unique` parameter:
n(my_scores, unique = TRUE)

# Total number of curated publications in the PGS Catalog:
all_pub <- get_publications(interactive = FALSE, progress_bar = FALSE)
n(all_pub)

# Total number of curated traits in the PGS Catalog:
all_traits <- get_traits(interactive = FALSE, progress_bar = FALSE)
n(all_traits)
\dontshow{\}) # examplesIf}
}
