% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/parSeqSim.R
\name{parSeqSim}
\alias{parSeqSim}
\title{Parallellized DNA/RNA Sequence Similarity Calculation based on Sequence Alignment}
\usage{
parSeqSim(dnalist, cores = 2, type = "local", submat = "BLOSUM62")
}
\arguments{
\item{dnalist}{A length \code{n} list containing \code{n} DNA/RNA sequences,
each component of the list is a character string, storing one DNA/RNA sequence.
Unknown sequences should be represented as \code{''}.}

\item{cores}{Integer. The number of CPU cores to use for parallel execution,
default is \code{2}. Users could use the \code{detectCores()} function
in the \code{parallel} package to see how many cores they could use.}

\item{type}{Type of alignment, default is \code{'local'},
could be \code{'global'} or \code{'local'},
where \code{'global'} represents Needleman-Wunsch global alignment;
\code{'local'} represents Smith-Waterman local alignment.}

\item{submat}{Substitution matrix, default is \code{'BLOSUM62'}, could be one of
\code{'BLOSUM45'}, \code{'BLOSUM50'}, \code{'BLOSUM62'}, \code{'BLOSUM80'}, \code{'BLOSUM100'},
\code{'PAM30'}, \code{'PAM40'}, \code{'PAM70'}, \code{'PAM120'}, \code{'PAM250'}.}
}
\value{
A \code{n} x \code{n} similarity matrix.
}
\description{
Parallellized DNA/RNA Sequence Similarity Calculation based on Sequence Alignment
}
\details{
This function implemented the parallellized version for calculating
DNA/RNA sequence similarity based on sequence alignment.
}
\examples{
\donttest{
# Be careful when testing this since it involves parallelisation
# and might produce unpredictable results in some environments

require(Biostrings)
require(foreach)
require(doParallel)

s1 = readFASTA(system.file('dnaseq/hs.fasta', package = 'rDNA'))[[1]]
s2 = readFASTA(system.file('dnaseq/hs.fasta', package = 'rDNA'))[[2]]
s3 = readFASTA(system.file('dnaseq/hs.fasta', package = 'rDNA'))[[3]]
s4 = readFASTA(system.file('dnaseq/hs.fasta', package = 'rDNA'))[[4]]
s5 = readFASTA(system.file('dnaseq/hs.fasta', package = 'rDNA'))[[5]]
plist = list(s1, s2, s3, s4, s5)
psimmat = parSeqSim(plist, cores = 2, type = 'local', submat = 'BLOSUM62')
print(psimmat)}
}
\author{
Min-feng Zhu  <\email{wind2zhu@163.com}>
}
\seealso{
See \code{twoSeqSim} for DNA/RNA sequence alignment
for two DNA/RNA sequences. See \code{\link{parGOSim}} for
DNA/RNA similarity calculation based on
Gene Ontology (GO) semantic similarity.
}
\keyword{alignment}
\keyword{parallel}
\keyword{similarity}

