% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.conversations.R
\name{ena.conversations}
\alias{ena.conversations}
\title{Find conversations by unit}
\usage{
ena.conversations(set, units, units.by = NULL, codes = NULL,
  conversation.exclude = c())
}
\arguments{
\item{set}{[TBD]}

\item{units}{[TBD]}

\item{units.by}{[TBD]}

\item{codes}{[TBD]}

\item{conversation.exclude}{[TBD]}
}
\value{
list containing row indices representing conversations
}
\description{
Find rows of conversations by unit
}
\details{
[TBD]
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
              'Client.and.Consultant.Requests','Design.Reasoning',
              'Collaboration');

accum = rENA::ena.accumulate.data(
  units = RS.data[,c("Condition","UserName")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre",
                        "CONFIDENCE.Post","C.Change")],
  codes = RS.data[,codeNames],
  model = "EndPoint",
  window.size.back = 4
);
set = ena.make.set(
  enadata = accum,
  rotation.by = ena.rotate.by.mean,
  rotation.params = list(accum$metadata$Condition=="FirstGame",
                         accum$metadata$Condition=="SecondGame")
);
ena.conversations(set, accum$unit.names[2], codes = set$enadata$codes)

}
