% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{bgi}
\alias{bgi}
\title{Calculate Low / High Blood Glucose Index (LBGI, HBGI)}
\usage{
bgi(x, unit = "mg", method = "manuscript")
}
\arguments{
\item{x}{vector of glucose readings}

\item{unit}{"mg" if the units are mg/dL or "mmol" if the units are mmol/L. Null value is "mg".}

\item{method}{"manuscript", "corrected", or "easy". Null value is "manuscript".}
}
\value{
A list containing the LBGI and HBGI values for a given dataset of glucose measurements.
}
\description{
Calculate Low / High Blood Glucose Index (LBGI, HBGI)
}
\examples{
bgi(x=c(rep(100, 10), rep(120, 10), 105, 85), unit='mg', method='manuscript')
}
