% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FindTreesCHM.R
\name{FindTreesCHM}
\alias{FindTreesCHM}
\title{Individual tree detection whitin the LiDAR-derived Canopy Height Model (CHM)}
\usage{
FindTreesCHM(chm,fws,minht)
}
\arguments{
\item{chm}{A LiDAR-derived Canopy Height Model (CHM) raster  file.}

\item{fws}{A single dimension (in raster grid cell units) of fixed square window size, e.g. 3, 5, 7 and so on. Default is 5.}

\item{minht}{Height threshold. Detect individual trees above specified height threshold, e.g. 1.37, 2.0, 3.5 m and so on. Default is 1.37 m.}
}
\value{
Returns A matrix with four columns (tree id, xy coordinates, and height).
}
\description{
Detects and computes the location and height of individual trees within the LiDAR-derived Canopy Height Model (CHM). The algorithm implemented in this function is local maximum with a fixed window size.
}
\examples{
# Importing the LiDAR-derived CHM raster file
data(chm) # or set a CHM. e.g. chm<-raster("CHM_stand.asc")

# Smoothing CHM
schm<-CHMsmoothing(chm, "mean", 5)

# Setting the fws:
fws<-5 # dimention 5x5

# Setting the specified height above ground for detectionbreak
minht<-8.0

# Getting the individual tree detection list
treeList<-FindTreesCHM(schm, fws, minht)
summary(treeList)

# Plotting the individual tree location on the CHM
library(raster)
plot(chm, main="LiDAR-derived CHM")
library(sp)
XY<-SpatialPoints(treeList[,1:2]) # Spatial points
plot(XY, add=TRUE, col="red")        # plotthing tree location
}
\author{
Carlos Alberto Silva
}

