% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LASmetrics.r
\name{LASmetrics}
\alias{LASmetrics}
\title{LiDAR metrics computation}
\usage{
LASmetrics(LASfile, minht, above)
}
\arguments{
\item{LASfile}{A LAS standard LiDAR data file}

\item{minht}{Use only returns above specified height break, e.g. 1.30 m. Default is 1.37 m.}

\item{above}{Compute covers metrics using specified height break, e.g. 2.5 m. Default is 2 m.}
}
\value{
Returns A matrix with the LiDAR-derived vegetation height and canopy cover metrics (see \emph{cloudmetrics}, in McGaughey, 2014)
}
\description{
Compute statistically based metrics that describe the LiDAR dataset
}
\examples{
#=======================================================================#
# Example 01: Computing LiDAR metrics for a single LAS file
#=======================================================================#
# Import the LAS data file
LASfile <- system.file("extdata", "LASexample1.las", package="rLiDAR")

# Set the minht and above parameters
minht<-1.37  # meters or feet
above<-2.00  # meters or feet

# LiDAR metrics computation
LiDARmetrics<-LASmetrics(LASfile, minht, above)

#==========================================================================#
# Example 02: Computing LiDAR metrics for multiple LAS files within a folder
#==========================================================================#
# Set folder where LAS source files reside
folder=dirname(LASfile)

# Get list of LAS files residing in the folder
LASlist <- list.files(folder, pattern="*.las", full.names=TRUE)

# Set the "minht" and "above" parameters
minht<-1.37  # meters or feet
above<-2.00  # meters or feet

# Creat an empty dataframe in whic to store the LiDAR metrics
getMetrics<-data.frame()

# Set a loop to compute the LiDAR metrics
for ( i in LASlist) {
 getMetrics<-rbind(getMetrics, LASmetrics(i, minht, above))}

# Table of the LiDAR metrics
LiDARmetrics<-cbind(Files=c(basename(LASlist)), getMetrics)
head(LiDARmetrics)
}
\author{
Carlos Alberto Silva
}
\seealso{
McGaughey, R. 2014. FUSION/LDV: Software for lidar data analysis and visualization. Version 3.41. Seattle, WA: U.S. Department of Agriculture, Forest Service, Pacific Northwest Research Station.
}

