% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rMetrics.r
\name{rMetrics}
\alias{rMetrics}
\title{Individual tree LiDAR metrics}
\usage{
rMetrics(xyziId)
}
\arguments{
\item{xyziId}{A 5-column matrix with the x, y, z coordinates, intensity and the tree id classification for the LiDAR point cloud.}
}
\value{
Returns A matrix of the LiDAR-based metrics for the individual tree detected.
}
\description{
This funtion computes LiDAR-based statistic metrics for individual trees detected from the 3D LiDAR point cloud.
}
\details{
# List of the individual tree LiDAR metrics:

# Total number of returns (TotalReturns);
# UTM Easting coordinate of the tree top (Etop);
# UTM Northing coordinate of the tree top (Ntop);
# Minimum UTM Easting coordinate (Emin);
# Minimum UTM Northing coordinate (Nmin);
# Maximum UTM Easting coordinate (Emax);
# Maxmium UTM Northing coordinate (Nmax);
# Tree crown width 01 (Ewidth);
# Tree crown width 02 (Nwidth);
# Maximum Height (hmax);
# Mean height (hmean);
# Standard deviation of height (hsd);
# Coefficient of variation of height (hcv);
# Mode of height (hmod);
# 5th percentile of height (h5);
# 10th percentile of height (h10);
# 20th percentile of height (h20);
# 25th percentile of height (h25);
# 30th percentile of height (h30);
# 40th percentile of height (h40);
# 50th percentile of height (h50);
# 60th percentile of height (h60);
# 70th percentile of height (h70);
# 75th percentile of height (h75);
# 80th percentile of height (h80);
# 90th percentile of height (h90);
# 95th percentile of height (h95);
# 99th percentile of height (h99);
# Maximum intensity (imax);
# Mean intensity (imean);
# Standard deviation of intensity (isd);
# Coefficient of variation of intensity (icv);
# Mode of intensity (imod);
# 5th percentile of intensity (i5);
# 10th percentile of intensity (i10);
# 20th percentile of intensity (i20);
# 25th percentile of intensity (i25);
# 30th percentile of intensity (i30);
# 40th percentile of intensity (i40);
# 50th percentile of intensity (i50);
# 60th percentile of intensity (i60);
# 70th percentile of intensity (i70);
# 75th percentile of intensity (i75);
# 80th percentile of intensity (i80);
# 90th percentile of intensity (i90);
# 95th percentile of intensity (i95);
# 99th percentile of intensity (i99).
}
\examples{
#=======================================================================#
# Individual tree detection using K-means cluster
#=======================================================================#
# Importing LAS file:
LASfile <- system.file("extdata", "LASexample1.las", package="rLiDAR")

# Reading LAS file
LAS<-readLAS(LASfile,short=TRUE)

# Setting the xyz coordinates and subsetting the data
xyzi<-subset(LAS[,1:4],LAS[,3] >= 1.37)

# Finding clusters (trees)
clLAS<-kmeans(xyzi[,1:2], 32)

# Set the tree id vector
Id<-as.factor(clLAS$cluster)

# Combining xyzi and tree id
xyziId<-cbind(xyzi,Id)

#=======================================================================#
#  Computing individual tree LiDAR metrics
#=======================================================================#

TreesMetrics<-rMetrics(xyziId)
head(TreesMetrics)
}
\author{
Carlos Alberto Silva
}

