% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_papers.R
\name{find_papers}
\alias{find_papers}
\title{Search for and Retrieve Paper Titles from PDB}
\usage{
find_papers(search_term, max_results = 10)
}
\arguments{
\item{search_term}{A string specifying the term to search for in the PDB.}

\item{max_results}{An integer indicating the maximum number of paper titles to retrieve.
Defaults to 10.}
}
\value{
A named list where each element's name is a PDB ID and its value is the title of the corresponding paper.
}
\description{
This function searches for papers in the Protein Data Bank (PDB) using a specified search term.
It retrieves the titles of papers up to a specified maximum number of results.
The function assumes the presence of `query_search` and `get_info` functions to perform the search and fetch paper details.
}
\examples{
\donttest{
find_papers("CRISPR")
}
}
