% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch.R
\name{pitch.cut}
\alias{pitch.cut}
\title{pitch.cut}
\usage{
pitch.cut(pitch, tStart = -Inf, tEnd = Inf)
}
\arguments{
\item{pitch}{Pitch object (either in Frame or Array format)}

\item{tStart}{beginning time of interval to be cut (default \code{-Inf} = cut from the \code{xmin} of the Pitch)}

\item{tEnd}{final time of interval to be cut (default \code{Inf} = cut to the \code{xmax} of the Pitch)}
}
\value{
Pitch object
}
\description{
Cut the specified interval from the Pitch object and preserve time
}
\examples{
pitch <- pitch.sample()
pitch2 <-   pitch.cut(pitch,  tStart = 3)
pitch2_0 <- pitch.cut0(pitch, tStart = 3)
pitch3 <-   pitch.cut(pitch,  tStart = 2, tEnd = 3)
pitch3_0 <- pitch.cut0(pitch, tStart = 2, tEnd = 3)
pitch4 <-   pitch.cut(pitch,  tEnd = 1)
pitch4_0 <- pitch.cut0(pitch, tEnd = 1)
pitch5 <-   pitch.cut(pitch,  tStart = -1, tEnd = 1)
pitch5_0 <- pitch.cut0(pitch, tStart = -1, tEnd = 1)
\dontrun{
pitch.plot(pitch)
pitch.plot(pitch2)
pitch.plot(pitch2_0)
pitch.plot(pitch3)
pitch.plot(pitch3_0)
pitch.plot(pitch4)
pitch.plot(pitch4_0)
pitch.plot(pitch5)
pitch.plot(pitch5_0)
}
}
\seealso{
\code{\link{pitch.cut0}}, \code{\link{tg.cut}}, \code{\link{tg.cut0}}, \code{\link{pitch.read}}, \code{\link{pitch.plot}}
}
