% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snd.R
\name{snd.read}
\alias{snd.read}
\title{snd.read}
\usage{
snd.read(
  fileNameSound,
  fileType = "auto",
  from = 1,
  to = Inf,
  units = "samples"
)
}
\arguments{
\item{fileNameSound}{Sound file name (.wav or .mp3)}

\item{fileType}{\code{"wav"}, \code{"mp3"} or \code{"auto"}}

\item{from}{Where to start reading in \code{units} (beginning \code{"samples"}: 1, \code{"seconds"}: 0)}

\item{to}{Where to stop reading in \code{units} (\code{Inf} = end of the file)}

\item{units}{Units of \code{from} and \code{to} arguments: \code{"samples"} (starting from 1) or \code{"seconds"} (starting from 0)}
}
\value{
Sound object with normalized amplitude (PCM / 2^(nbits-1) - 1) resulting to the range of [-1; +1]. In fact, the minimum value can be one quantization step lower (e.g. PCM 16bit: -32768).
\code{t}   ... vector of discrete time instances (seconds)
\code{sig} ... signal matrix (\code{nrow(snd$sig)} = number of samples, \code{ncol(snd$sig)} = number of channels, i.e., \code{$sig[, 1]} ... 1st channel)
\code{fs}  ... sample rate (Hz)
\code{nChannels} ... number of signal channels (\code{ncol(snd$sig)}), 1 == mono, 2 == stereo
\code{nBits}     ... number of bits ped one sample
\code{nSamples}  ... number of samples (\code{nrow(snd$sig)})
\code{duration}  ... duration of signal (seconds), \code{snd$duration == snd$nSamples/snd$fs}
}
\description{
Loads sound file (.wav or .mp3) using tuneR package.
}
\examples{
\dontrun{
snd <- snd.read("demo/H.wav")
snd.plot(snd)
}
}
