% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde_intrinsic.R
\name{rspde.matern.intrinsic}
\alias{rspde.matern.intrinsic}
\alias{rspde.intrinsic.matern}
\title{Intrinsic Matern rSPDE model object for INLA}
\usage{
rspde.intrinsic.matern(
  mesh,
  alpha = 2,
  mean.correction = FALSE,
  prior.lkappa.mean = NULL,
  prior.ltau.mean = 1,
  prior.lkappa.prec = 0.1,
  prior.ltau.prec = 0.1,
  start.ltau = NULL,
  start.lkappa = NULL,
  true.scaling = TRUE,
  diagonal = 0,
  debug = FALSE,
  shared_lib = "detect",
  ...
)
}
\arguments{
\item{mesh}{The mesh to build the model. It can be an \code{inla.mesh} or
an \code{inla.mesh.1d} object. Otherwise, should be a list containing elements d, the dimension, C, the mass matrix,
and G, the stiffness matrix.}

\item{alpha}{Smoothness parameter, need to be 1 or 2.}

\item{mean.correction}{Add mean correction for extreme value models?}

\item{prior.lkappa.mean}{Prior on log kappa to be used for the priors and for the starting values.}

\item{prior.ltau.mean}{Prior on log tau to be used for the priors and for the starting values.}

\item{prior.lkappa.prec}{Precision to be used on the prior on log kappa to be used for the priors and for the starting values.}

\item{prior.ltau.prec}{Precision to be used on the prior on log tau to be used for the priors and for the starting values.}

\item{start.ltau}{Starting value for log of tau.}

\item{start.lkappa}{Starting value for log of kappa.}

\item{true.scaling}{Compute the true normalizing constant manually? Default \code{TRUE}.
The alternative is to set this to \code{FALSE} and set the \code{diagonal} argument to some small
positive value. In the latter case, the model is approximated by a non-intrinsic model
with a precision matrix that has the \code{diagonal} value added to the diagonal.}

\item{diagonal}{Value of diagonal correction for INLA stability. Default 0.}

\item{debug}{INLA debug argument}

\item{shared_lib}{Which shared lib to use for the cgeneric implementation?
If "detect", it will check if the shared lib exists locally, in which case it will
use it. Otherwise it will use INLA's shared library.
If "INLA", it will use the shared lib from INLA's installation. If 'rSPDE', then
it will use the local installation (does not work if your installation is from CRAN).
Otherwise, you can directly supply the path of the .so (or .dll) file.}

\item{...}{Only being used internally.}
}
\value{
An INLA model.
}
\description{
Creates an INLA object for a stationary intrinsic Matern model.
Currently, alpha is fixed to 2 and beta is fixed to 1.
}
