% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_heat_map.R
\name{get_heat_map}
\alias{get_heat_map}
\alias{get_heat_map.list}
\alias{get_heat_map.actframe}
\alias{get_heat_map.strframe}
\title{Makes a heat map from your activity data}
\usage{
get_heat_map(act_data, ...)

\method{get_heat_map}{list}(
  act_data,
  key,
  acts = 1,
  id = NULL,
  alpha = NULL,
  add_elev = FALSE,
  as_grad = FALSE,
  distlab = TRUE,
  distval = 0,
  size = 0.5,
  col = "red",
  expand = 10,
  maptype = "cartolight",
  zoom = NULL,
  units = "metric",
  ...
)

\method{get_heat_map}{actframe}(
  act_data,
  key,
  alpha = NULL,
  add_elev = FALSE,
  as_grad = FALSE,
  distlab = TRUE,
  distval = 0,
  size = 0.5,
  col = "red",
  expand = 10,
  maptype = "cartolight",
  zoom = NULL,
  ...
)

\method{get_heat_map}{strframe}(
  act_data,
  alpha = NULL,
  filltype = "elevation",
  distlab = TRUE,
  distval = 0,
  size = 0.5,
  col = "red",
  expand = 10,
  maptype = "cartolight",
  zoom = NULL,
  ...
)
}
\arguments{
\item{act_data}{an activities list object returned by \code{\link{get_activity_list}}, an \code{actframe} returned by \code{\link{compile_activities}}, or a \code{strfame} returned by \code{\link{get_activity_streams}}}

\item{...}{arguments passed to or from other methods}

\item{key}{chr string of Google API key for elevation data, passed to \code{\link[googleway]{google_elevation}} for polyline decoding, see details}

\item{acts}{numeric indicating which activities to plot based on index in the activities list, defaults to most recent}

\item{id}{optional numeric vector to specify the id(s) of the activity/activities to plot, \code{acts} is ignored if provided}

\item{alpha}{the opacity of the line desired. A single activity should be 1. Defaults to 0.5}

\item{add_elev}{logical indicating if elevation is overlayed by color shading on the activity lines}

\item{as_grad}{logical indicating if elevation is plotted as percent gradient, applies only if \code{add_elev = TRUE}}

\item{distlab}{logical if distance labels are plotted along the route}

\item{distval}{numeric indicating rounding factor for distance labels which has direct control on label density, see details}

\item{size}{numeric indicating width of activity lines}

\item{col}{chr string indicating either a single color of the activity lines if \code{add_grad = FALSE} or a color palette passed to \code{\link[ggplot2]{scale_fill_distiller}} if \code{add_grad = TRUE}}

\item{expand}{a numeric multiplier for expanding the number of lat/lon points on straight lines.  This can create a smoother elevation gradient if \code{add_grad = TRUE}.  Set \code{expand = 1} to suppress this behavior.}

\item{maptype}{chr string as \code{"cartolight"}, \code{"cartodark"}, \code{"osm"}, or \code{"hotstyle"} indicating the basemap type}

\item{zoom}{numeric indicating zoom factor for map tiles, higher numbers increase resolution}

\item{units}{chr string indicating plot units as either metric or imperial, this has no effect if input data are already compiled with \code{\link{compile_activities}}}

\item{filltype}{chr string specifying which stream variable to use for filling line segments, applies only to \code{strframe} objects, acceptable values are \code{"elevation"}, \code{"distance"}, \code{"slope"}, or \code{"speed"}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object showing a map with activity locations.
}
\description{
Makes a heat map from your activity data
}
\details{
uses \code{\link{get_latlon}} to produce a dataframe of latitudes and longitudes to use in the map. Uses ggspatial to produce the map and ggplot2 to plot the route.

A Google API key is needed for the elevation data and must be included with function execution.  The API key can be obtained following the instructions here: https://developers.google.com/maps/documentation/elevation/#api_key

The \code{distval} argument is passed to the \code{digits} argument of \code{round}. This controls the density of the distance labels, e.g., 1 will plot all distances in sequence of 0.1, 0 will plot all distances in sequence of one, -1 will plot all distances in sequence of 10, etc.
}
\examples{
\dontrun{
# get my activities
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))
my_acts <- get_activity_list(stoken)

# default, requires Google key
mykey <- 'Get Google API key'
get_heat_map(my_acts, acts = 1, alpha = 1, key = mykey)

# plot elevation on locations, requires key
get_heat_map(my_acts, acts = 1, alpha = 1, key = mykey, add_elev = TRUE, col = 'Spectral', size = 2)

# compile first, change units
my_acts <- compile_activities(my_acts, acts = 156, units = 'imperial')
get_heat_map(my_acts, key = mykey, alpha = 1, add_elev = T, col = 'Spectral', size = 2)
}
}
\author{
Daniel Padfield, Marcus Beck
}
\concept{token}
