% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{cost.FMGS}
\alias{cost.FMGS}
\alias{flow.dispersion}
\title{Compute flow-based cost or conductance}
\usage{
cost.FMGS(wind.direction, wind.speed, target, type = "active")

flow.dispersion(x, fun = cost.FMGS, output = "transitionLayer", ...)
}
\arguments{
\item{wind.direction}{A vector or scalar containing wind directions.}

\item{wind.speed}{A vector or scalar containing wind speeds.}

\item{target}{direction of the target cell}

\item{type}{Could be either "passive" or "active".In "passive" mode,
movement against flow direction is not allowed (deviations from the wind
direction higher than 90). In "active" mode, the movement can go against flow
direction, by increasing the cost.}

\item{x}{RasterStack object with layers obtained from wind2raster
function ("rWind" package) with direction and speed flow values.}

\item{fun}{A function to compute the cost to move between cells. The default
is \code{cost.FMGS} from Felicísimo et al. (2008), see details.}

\item{output}{This argument allows to select different kinds of output. "raw"
mode creates a matrix (class "dgCMatrix") with transition costs between all
cells in the raster. "transitionLayer" creates a TransitionLayer object with
conductance values to be used with "gdistance" package.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
In "transitionLayer" output, the function returns conductance values
(1/cost)to move between all cells in a raster having into account flow speed
and direction obtained from wind.fit function("rWind" package). As wind or
sea currents implies directionality, flow.dispersion produces an anisotropic
conductance matrix (asymmetric). Conductance values are used later to built a
TransitionLayer object from "gdistance" package.

In "raw" output, flow.dispersion creates a sparse Matrix with cost values.
}
\description{
\code{flow.dispersion} computes movement conductance through a flow either, sea
or wind currents. It implements the formula described in Felícisimo et al.
2008:
}
\details{
Cost=(1/Speed)*(HorizontalFactor)

being HorizontalFactor a "function that incrementally penalized angular
deviations from the wind direction" (Felicísimo et al. 2008).
}
\note{
Note that for large data sets, it could take a while. For large study
areas is strongly advised perform the analysis in a remote computer or a
cluster.
}
\examples{

require(gdistance)

data(wind.data)

wind <- wind2raster(wind.data)

Conductance <- flow.dispersion(wind, type = "passive")

transitionMatrix(Conductance)
image(transitionMatrix(Conductance))
}
\references{
Felicísimo, Á. M., Muñoz, J., & González-Solis, J. (2008). Ocean surface
winds drive dynamics of transoceanic aerial movements. PLoS One, 3(8),
e2928.

Jacob van Etten (2017). R Package gdistance: Distances and Routes on
Geographical Grids. Journal of Statistical Software, 76(13), 1-21.
doi:10.18637/jss.v076.i13
}
\seealso{
\code{\link{wind.dl}}, \code{\link{wind2raster}}
}
\author{
Javier Fernández-López; Klaus Schliep; Yurena Arjona
}
\keyword{~anisotropy}
\keyword{~conductance}
