% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{hapHeatmap}
\alias{hapHeatmap}
\title{Graphical output of alleles division by chromosome}
\usage{
hapHeatmap(hap_table, chain = c("IGH", "IGK", "IGL"),
  gene_sort = "position", removeIGH = TRUE, lk_cutoff = 1,
  mark_low_lk = TRUE)
}
\arguments{
\item{hap_table}{haplotype summary table. See details.}

\item{chain}{the IG chain: IGH,IGK,IGL. Default is IGH.}

\item{gene_sort}{if by 'name' the genes in the output are ordered lexicographically,
if by 'position' only functional genes are used and are ordered by their chromosomal location. Default is 'position'.}

\item{removeIGH}{if TRUE, 'IGH'\'IGK'\'IGL' prefix is removed from gene names.}

\item{lk_cutoff}{the lK cutoff value to be considerd low for texture layer. Defualt is lK<1.}

\item{mark_low_lk}{if TRUE, a texture is add for low lK values. Defualt is TRUE.}
}
\value{
A heat-map visualization of the haplotype inference for multiple samples.
}
\description{
The \code{hapHeatmap} function generates a graphical output of the alleles per gene in multiple samples.
}
\details{
A \code{data.frame} created by \code{createFullHaplotype}.
}
\examples{
# Plotting haplotpe heatmap
hapHeatmap(samplesHaplotype)

}
