% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_densities.R
\name{create_densities}
\alias{create_densities}
\title{Create Densities}
\usage{
create_densities(x, y, window_size)
}
\arguments{
\item{x}{RasterStack with realizations}

\item{y}{RasterStack with shares of subpopulations}

\item{window_size}{Size, expressed in the number of cells, of a square-shaped local window for which local densities will be calculated; it is recommended to use the small window_size, i.e., 10}
}
\value{
a RasterStack containing n local densities. Local density layer is calculated for each realization
}
\description{
Calculate local densities of subpopulations (race-specific local densities)
}
\examples{
library(raster)
real_rasters = create_realizations(race_raster, n = 5)
plot(real_rasters)
dens_raster = create_densities(real_rasters, race_raster, window_size = 10)
dens_raster
plot(dens_raster)

}
