% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/glm_reg.R
\name{plot.glm_reg}
\alias{plot.glm_reg}
\title{Plot method for the glm_reg function}
\usage{
\method{plot}{glm_reg}(x, glm_plots = "", glm_conf_level = 0.95,
  glm_coef_int = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{glm_reg}}}

\item{glm_plots}{Plots to produce for the specified GLM model. Use "" to avoid showing any plots (default). "hist" shows histograms of all variables in the model. "scatter" shows scatter plots (or box plots for factors) for the dependent variable with each independent variable. "dashboard" is a series of four plots used to visually evaluate model. "coef" provides a coefficient plot}

\item{glm_conf_level}{Confidence level to use for coefficient and odds confidence intervals (.95 is the default)}

\item{glm_coef_int}{Include the intercept in the coefficient plot (TRUE or FALSE). FALSE is the default}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the glm_reg function
}
\details{
See \url{http://vnijs.github.io/radiant/quant/glm_reg.html} for an example in Radiant
}
\examples{
result <- glm_reg("titanic", "survived", c("pclass","sex"), glm_levels = "Yes")
plot(result, glm_plots = "coef")
}
\seealso{
\code{\link{glm_reg}} to generate results

\code{\link{plot.glm_reg}} to plot results

\code{\link{predict.glm_reg}} to generate predictions

\code{\link{plot.glm_predict}} to plot prediction output
}

