% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qn.R
\name{qn}
\alias{qn}
\title{quasi-Newton algorithm for ancestry analysis}
\usage{
qn(g, q, f, tol = 1e-4, method, model)
}
\arguments{
\item{g}{Genotype matrix with dimensions \eqn{n × p}, where n is sample size
and p is the number of SNPs.}

\item{q}{Ancestry coefficient matrix with dimensions \eqn{n × K}, where n
is sample size and K is the number of populations.}

\item{f}{Minor allele frequency matrix with dimensions \eqn{K × p},
where K is the number of populations and p is the number of SNPs.}

\item{tol}{Tolerance, the default value is 1e-4.}

\item{method}{Choose which algorithm you want to use. EM or BR.}

\item{model}{Choose which model you want to use. Supervised learning or unsupervised learning.}
}
\value{
Estimation results of q, f and the loglikelihood value of each iteration.
}
\description{
Use quasi-Newton algorithm to accelerate EM or block relaxation.
}
\examples{
## qn(g, q, f, tol = 1e-4, method = 'BR', model = 'supervised')
}
