% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_search_beta_by_E.R
\name{RN_search_beta_by_E}
\alias{RN_search_beta_by_E}
\title{Search for beta}
\usage{
RN_search_beta_by_E(E_max, min_half_life_seconds = NULL,
  max_half_life_seconds = NULL)
}
\arguments{
\item{E_max}{maximum energy in MeV, default = 10}

\item{min_half_life_seconds}{minimum half-life in seconds.
Use multiplier as needed, e.g. 3 * 3600 for 3 hours. Default = NULL,}

\item{max_half_life_seconds}{maximum half-life. See min_half_life_seconds.}
}
\value{
search results in order of half-life. Recommend assigning
results to a viewable object, such as 'search_results'
}
\description{
Search for beta emission based on maximum energy and half-life.
}
\examples{
# Max beta at least 2 MeV
search_results <- RN_search_beta_by_E(2)
# Max beta at least 2 MeV and half-life between 1 s and 1 h
search_results <- RN_search_beta_by_E(2, 1, 3600)

# Max beta at least 1 MeV and half-life between 1 d and 2 d
search_results <- RN_search_beta_by_E(1, 3600 * 24, 2 * 3600 * 24)
}
\seealso{
[RN_plt()]

Other radionuclides: \code{\link{RN_Spec_Act}},
  \code{\link{RN_index_screen}}, \code{\link{RN_info}},
  \code{\link{RN_plot_search_results}},
  \code{\link{RN_plot_spectrum}},
  \code{\link{RN_save_spectrum}},
  \code{\link{RN_search_alpha_by_E}},
  \code{\link{RN_search_phot_by_E}},
  \code{\link{bin_screen_phot}},
  \code{\link{search_alpha_by_E}},
  \code{\link{search_beta_by_E}},
  \code{\link{search_phot_by_E}}
}
\concept{radionuclides}
