% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instruments.R
\docType{class}
\name{CouponBond-class}
\alias{CouponBond}
\alias{CouponBond-class}
\title{Standard corporate or government bond}
\description{
A coupon bond is treated here as the entire collection of cashflows. In particular,
 coupons are included in the package even after they have been paid, accruing
 at the risk-free rate.
}
\section{Fields}{

\describe{
\item{\code{coupons}}{A data.frame of details for each coupon.  It should have the
columns \code{payment_time} and \code{payment_size}.}
}}
\section{Methods}{

\describe{
\item{\code{accumulate_coupon_values_before(t, discount_factor_fctn = discount_factor_fcn)}}{Compute the sum of coupon present values as of {t} according to {discount_factor_fctn}}

\item{\code{critical_times()}}{Important times in the life of this instrument for simulation and grid solvers}

\item{\code{optionality_fcn(v, S, t, ...)}}{Return the notional value in the shape of {S} at any time on or after maturity, otherwise just return {v}}

\item{\code{total_coupon_values_between(small_t, big_t,
  discount_factor_fctn = discount_factor_fcn)}}{Compute the sum (as of {big_t}) of present values of coupons paid between small_t and big_t}

\item{\code{update_cashflows(small_t, big_t, discount_factor_fctn = discount_factor_fcn,
  include_notional = TRUE, ...)}}{Update last_computed_cash and return cashflow information for the given time period, valued at big_t}
}}

