/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_Normal;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.variables.Variable;
import java.util.Random;

public class Normal
extends UnivariateDistribution {
    private static final long serialVersionUID = -5498079146465770364L;
    private double mean;
    private double variance;

    public Normal(Variable var1) {
        this.var = var1;
        this.mean = 0.0;
        this.variance = 1.0;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean1) {
        this.mean = mean1;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double var) {
        this.variance = var;
    }

    public double getSd() {
        return Math.sqrt(this.variance);
    }

    @Override
    public double[] getParameters() {
        return new double[]{this.mean, this.getVariance()};
    }

    @Override
    public int getNumberOfParameters() {
        return 2;
    }

    @Override
    public double getProbability(double value) {
        return Math.exp(this.getLogProbability(value));
    }

    @Override
    public double getLogProbability(double value) {
        return -0.5 * Math.log(this.variance) - 0.5 * Math.log(Math.PI * 2) - 0.5 * Math.pow(value - this.mean, 2.0) / this.variance;
    }

    @Override
    public double sample(Random rand) {
        return rand.nextGaussian() * this.getSd() + this.getMean();
    }

    @Override
    public UnivariateDistribution deepCopy(Variable variable) {
        Normal copy = new Normal(variable);
        copy.setMean(this.getMean());
        copy.setVariance(this.getVariance());
        return copy;
    }

    @Override
    public String label() {
        return "Normal";
    }

    @Override
    public void randomInitialization(Random random) {
        this.setMean(random.nextGaussian() * 10.0);
        this.setVariance(random.nextDouble() * 10.0 + 0.5);
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof Normal) {
            return this.equalDist((Normal)dist, threshold);
        }
        return false;
    }

    @Override
    public String toString() {
        return "Normal [ mu = " + this.getMean() + ", var = " + this.getVariance() + " ]";
    }

    public boolean equalDist(Normal dist, double threshold) {
        return Math.abs(this.getMean() - dist.getMean()) <= threshold && Math.abs(this.getSd() - dist.getSd()) <= threshold;
    }

    public EF_Normal toEFUnivariateDistribution() {
        EF_Normal efNormal = new EF_Normal(this.getVariable());
        MomentParameters momentParameters = efNormal.createZeroMomentParameters();
        momentParameters.set(0, this.getMean());
        momentParameters.set(1, this.getMean() * this.getMean() + this.getVariance());
        efNormal.setMomentParameters(momentParameters);
        efNormal.updateNaturalFromMomentParameters();
        return efNormal;
    }
}

