/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;

public class EF_JointNormalGamma
extends EF_UnivariateDistribution {
    public static final int MU_GAMMA = 0;
    public static final int MUSQUARE_GAMMA = 1;
    public static final int GAMMA = 2;
    public static final int LOGGAMMA = 3;

    public EF_JointNormalGamma(Variable var1) {
        if (!var1.isNormalGammaParameter()) {
            throw new IllegalArgumentException("The variable is not a Gamma parameter!");
        }
        this.parents = new ArrayList();
        this.var = var1;
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        double alpha = 1.0;
        double beta = 1.0;
        double mean = 0.0;
        double precision = 1.0E-10;
        this.naturalParameters.set(0, mean * precision);
        this.naturalParameters.set(1, -0.5 * precision);
        this.naturalParameters.set(2, -beta - 0.5 * precision * mean * mean);
        this.naturalParameters.set(3, alpha - 0.5);
        this.setNaturalParameters(this.naturalParameters);
    }

    @Override
    public double computeLogBaseMeasure(double val) {
        return -0.5 * Math.log(Math.PI * 2);
    }

    @Override
    public SufficientStatistics getSufficientStatistics(double val) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public EF_UnivariateDistribution deepCopy(Variable var) {
        EF_JointNormalGamma copy = new EF_JointNormalGamma(var);
        copy.getNaturalParameters().copy(this.getNaturalParameters());
        copy.getMomentParameters().copy(this.getMomentParameters());
        return copy;
    }

    @Override
    public EF_UnivariateDistribution randomInitialization(Random random) {
        double randomVar = random.nextDouble() * 2.0 + 1.0 + 0.01;
        double alpha = 10.0;
        double beta = randomVar * alpha;
        double mean = random.nextGaussian() * 10.0;
        double var = random.nextDouble() * 10.0 + 1.0;
        double precision = 1.0 / var;
        this.naturalParameters.set(0, mean * precision);
        this.naturalParameters.set(1, -0.5 * precision);
        this.naturalParameters.set(2, -beta - 0.5 * precision * mean * mean);
        this.naturalParameters.set(3, alpha - 0.5);
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
        return this;
    }

    @Override
    public <E extends UnivariateDistribution> E toUnivariateDistribution() {
        throw new UnsupportedOperationException("Gamma is not included yet in the Distributions package.");
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        double alpha = this.naturalParameters.get(3) + 0.5;
        double precision = this.naturalParameters.get(1) / -0.5;
        double mean = this.naturalParameters.get(0) / precision;
        double beta = -this.naturalParameters.get(2) - 0.5 * precision * mean * mean;
        this.momentParameters.set(0, mean * alpha / beta);
        this.momentParameters.set(1, 1.0 / precision + mean * mean * alpha / beta);
        this.momentParameters.set(2, alpha / beta);
        this.momentParameters.set(3, Gamma.digamma(alpha) - Math.log(beta));
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 4;
    }

    @Override
    public double computeLogNormalizer() {
        double alpha = this.naturalParameters.get(3) + 0.5;
        double precision = this.naturalParameters.get(1) / -0.5;
        double mean = this.naturalParameters.get(0) / precision;
        double beta = -this.naturalParameters.get(2) - 0.5 * precision * mean * mean;
        return -0.5 * Math.log(precision) - alpha * Math.log(beta) + Gamma.logGamma(alpha);
    }

    @Override
    public Vector createZeroVector() {
        return new ArrayVector(4);
    }

    @Override
    public Vector getExpectedParameters() {
        double precision = this.momentParameters.get(2);
        double mean = this.momentParameters.get(0) / precision;
        ArrayVector vec = new ArrayVector(2);
        vec.set(0, mean);
        vec.set(1, precision);
        return vec;
    }

    @Override
    public void fixNumericalInstability() {
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        ArrayVector vector = new ArrayVector(this.sizeOfSufficientStatistics());
        double alpha = 1.0;
        double beta = 1.0;
        double mean = 0.0;
        double precision = 1.0E-10;
        this.momentParameters.set(0, mean * alpha / beta);
        this.momentParameters.set(1, 1.0 / precision + mean * mean * alpha / beta);
        this.momentParameters.set(2, alpha / beta);
        this.momentParameters.set(3, Gamma.digamma(alpha) - Math.log(beta));
        return vector;
    }
}

