/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Distribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.ParameterVariables;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.models.DAG;
import eu.amidst.core.utils.CompoundVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class EF_LearningBayesianNetwork
extends EF_Distribution {
    List<EF_ConditionalDistribution> distributionList;
    ParameterVariables parametersVariables;
    List<Variable> non_expand;

    public EF_LearningBayesianNetwork(DAG dag) {
        this.non_expand = new ArrayList<Variable>();
        this.parametersVariables = new ParameterVariables(dag.getVariables().getNumberOfVars());
        this.distributionList = dag.getVariables().getListOfVariables().stream().map(var -> ((EF_Distribution)((DistributionType)var.getDistributionType()).newEFConditionalDistribution(dag.getParentSet((Variable)var).getParents())).toExtendedLearningDistribution(this.parametersVariables)).flatMap(listOfDist -> listOfDist.stream()).sorted((a, b) -> a.getVariable().getVarID() - b.getVariable().getVarID()).collect(Collectors.toList());
        this.naturalParameters = null;
        this.momentParameters = null;
    }

    public EF_LearningBayesianNetwork(List<EF_ConditionalDistribution> distributions) {
        this(distributions, new ArrayList<Variable>());
    }

    public EF_LearningBayesianNetwork(List<EF_ConditionalDistribution> distributions, List<Variable> non_expand) {
        this.non_expand = non_expand;
        this.parametersVariables = new ParameterVariables(distributions.size());
        this.distributionList = distributions.stream().map(dist -> {
            if (this.non_expand.contains(dist.getVariable())) {
                return Arrays.asList(dist);
            }
            return dist.toExtendedLearningDistribution(this.parametersVariables);
        }).flatMap(listOfDist -> listOfDist.stream()).sorted((a, b) -> a.getVariable().getVarID() - b.getVariable().getVarID()).collect(Collectors.toList());
        this.naturalParameters = null;
        this.momentParameters = null;
    }

    public ParameterVariables getParametersVariables() {
        return this.parametersVariables;
    }

    public List<Variable> getListOfParametersVariables() {
        return this.parametersVariables.getListOfParamaterVariables();
    }

    public List<Variable> getListOfNonParameterVariables() {
        return this.distributionList.stream().map(dist -> dist.getVariable()).filter(var -> !var.isParameterVariable()).collect(Collectors.toList());
    }

    public List<ConditionalDistribution> toConditionalDistribution() {
        ArrayList<ConditionalDistribution> condDistList = new ArrayList();
        for (EF_ConditionalDistribution dist : this.distributionList) {
            if (dist.getVariable().isParameterVariable()) continue;
            if (this.non_expand.contains(dist.getVariable())) {
                condDistList.add((ConditionalDistribution)dist.toConditionalDistribution());
                continue;
            }
            EF_ConditionalDistribution distLearning = dist;
            HashMap<Variable, Vector> expectedParameters = new HashMap<Variable, Vector>();
            for (Variable var : distLearning.getConditioningVariables()) {
                if (!var.isParameterVariable()) continue;
                EF_UnivariateDistribution uni = (EF_UnivariateDistribution)this.distributionList.get(var.getVarID());
                expectedParameters.put(var, uni.getExpectedParameters());
            }
            condDistList.add(distLearning.toConditionalDistribution(expectedParameters));
        }
        condDistList = condDistList.stream().sorted((a, b) -> a.getVariable().getVarID() - b.getVariable().getVarID()).collect(Collectors.toList());
        return condDistList;
    }

    public List<EF_ConditionalDistribution> getDistributionList() {
        return this.distributionList;
    }

    public <E extends EF_ConditionalDistribution> E getDistribution(Variable var) {
        return (E)this.distributionList.get(var.getVarID());
    }

    public void setDistribution(Variable var, EF_ConditionalDistribution dist) {
        this.distributionList.set(var.getVarID(), dist);
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public int sizeOfSufficientStatistics() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public double computeLogNormalizer() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public Vector createZeroVector() {
        throw new UnsupportedOperationException("This method does not apply in this case!");
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        return new CompoundVector(this.distributionList.stream().map(w -> w.createInitSufficientStatistics()).collect(Collectors.toList()));
    }
}

