/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.learning.parametric.bayesian.utils;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataPosterior
implements Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    final long id;
    final Map<Variable, UnivariateDistribution> map;

    public DataPosterior(long id_, List<UnivariateDistribution> posteriors_) {
        this.id = id_;
        this.map = new HashMap<Variable, UnivariateDistribution>();
        for (UnivariateDistribution univariateDistribution : posteriors_) {
            this.map.put(univariateDistribution.getVariable(), univariateDistribution);
        }
    }

    public long getId() {
        return this.id;
    }

    public UnivariateDistribution getPosterior(Variable var) {
        return this.map.get(var);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("ID: " + this.id + " | ");
        for (Map.Entry<Variable, UnivariateDistribution> entry : this.map.entrySet()) {
            string.append(entry.getKey().getName() + ", ");
            string.append(" |  ");
            string.append(entry.getValue().toString() + ", ");
        }
        return string.toString();
    }

    public boolean isPresent(Variable var) {
        return this.map.containsKey(var);
    }
}

