/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.datastream;

import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.DataOnMemoryListContainer;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.dynamic.datastream.DataSequence;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DataSequenceSpliterator
implements Spliterator<DataSequence> {
    private final DataStream<DynamicDataInstance> dataStream;
    private final Spliterator<DynamicDataInstance> spliterator;
    private final int characteristics;
    private long est;
    private DynamicDataInstance tailInstance = null;
    private boolean advance = true;

    public DataSequenceSpliterator(DataStream<DynamicDataInstance> dataStream_, long est) {
        this.dataStream = dataStream_;
        this.spliterator = this.dataStream.stream().spliterator();
        int c = this.spliterator.characteristics();
        this.characteristics = (c & 0x40) != 0 ? c | 0x4000 : c;
        this.est = est;
    }

    public DataSequenceSpliterator(DataStream<DynamicDataInstance> dataStream_) {
        this(dataStream_, dataStream_.stream().spliterator().estimateSize());
    }

    public static Stream<DataSequence> toDataSequenceStream(DataStream<DynamicDataInstance> dataStream_) {
        return StreamSupport.stream(new DataSequenceSpliterator(dataStream_), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Spliterator<DataSequence> trySplit() {
        if (!this.advance) {
            return null;
        }
        HoldingConsumer holder = new HoldingConsumer();
        DataSequenceImpl container = new DataSequenceImpl(this.dataStream.getAttributes());
        Object[] a = new DataSequenceImpl[]{container};
        if (this.tailInstance == null) {
            if (!this.spliterator.tryAdvance(holder)) return null;
            this.tailInstance = (DynamicDataInstance)holder.value;
            container.add(this.tailInstance);
        } else {
            container.add(this.tailInstance);
        }
        container.setSeqId(this.tailInstance.getSequenceID());
        while ((this.advance = this.spliterator.tryAdvance(holder)) && ((DynamicDataInstance)holder.value).getSequenceID() == this.tailInstance.getSequenceID()) {
            this.tailInstance = (DynamicDataInstance)holder.value;
            container.add(this.tailInstance);
        }
        this.tailInstance = (DynamicDataInstance)holder.value;
        if (this.est != Long.MAX_VALUE) {
            this.est -= (long)container.getNumberOfDataInstances();
        }
        if (container.getNumberOfDataInstances() <= 0) return null;
        return Spliterators.spliterator(a, 0, 1, this.characteristics());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean tryAdvance(Consumer<? super DataSequence> action) {
        if (!this.advance) {
            return false;
        }
        HoldingConsumer holder = new HoldingConsumer();
        DataSequenceImpl container = new DataSequenceImpl(this.dataStream.getAttributes());
        if (this.tailInstance == null) {
            if (!this.spliterator.tryAdvance(holder)) return false;
            this.tailInstance = (DynamicDataInstance)holder.value;
            container.add(this.tailInstance);
        } else {
            container.add(this.tailInstance);
        }
        container.setSeqId(this.tailInstance.getSequenceID());
        while ((this.advance = this.spliterator.tryAdvance(holder)) && ((DynamicDataInstance)holder.value).getSequenceID() == this.tailInstance.getSequenceID()) {
            this.tailInstance = (DynamicDataInstance)holder.value;
            container.add(this.tailInstance);
        }
        this.tailInstance = (DynamicDataInstance)holder.value;
        if (this.est != Long.MAX_VALUE) {
            this.est -= (long)container.getNumberOfDataInstances();
        }
        if (container.getNumberOfDataInstances() <= 0) return false;
        action.accept(container);
        return true;
    }

    @Override
    public Comparator<? super DataSequence> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    static class DataSequenceImpl
    extends DataOnMemoryListContainer<DynamicDataInstance>
    implements DataSequence,
    Serializable {
        private static final long serialVersionUID = 4107783324901370839L;
        long seqId = 0L;

        public DataSequenceImpl(Attributes attributes_) {
            super(attributes_);
        }

        public void setSeqId(long seqId) {
            this.seqId = seqId;
        }

        @Override
        public long getSequenceID() {
            return this.seqId;
        }
    }

    static final class HoldingConsumer<T>
    implements Consumer<T> {
        T value;

        HoldingConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }
}

