/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.exponentialfamily;

import eu.amidst.core.exponentialfamily.EF_BayesianNetwork;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.Vector;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.exponentialfamily.EF_DynamicDistribution;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.models.DynamicDAG;
import java.util.stream.Collectors;

public class EF_DynamicBayesianNetwork
extends EF_DynamicDistribution {
    EF_BayesianNetwork bayesianNetworkTime0;
    EF_BayesianNetwork bayesianNetworkTimeT;

    public EF_DynamicBayesianNetwork(DynamicDAG dag) {
        this.bayesianNetworkTime0 = new EF_BayesianNetwork(dag.getParentSetsTime0());
        this.bayesianNetworkTimeT = new EF_BayesianNetwork(dag.getParentSetsTimeT());
    }

    public EF_DynamicBayesianNetwork(DynamicBayesianNetwork dbn) {
        this.bayesianNetworkTime0 = new EF_BayesianNetwork();
        this.bayesianNetworkTimeT = new EF_BayesianNetwork();
        this.bayesianNetworkTime0.setDistributionList(dbn.getConditionalDistributionsTime0().stream().map(dist -> dist.toEFConditionalDistribution()).collect(Collectors.toList()));
        this.bayesianNetworkTimeT.setDistributionList(dbn.getConditionalDistributionsTimeT().stream().map(dist -> dist.toEFConditionalDistribution()).collect(Collectors.toList()));
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        DynamiceBNCompoundVector globalMomentsParam = (DynamiceBNCompoundVector)this.momentParameters;
        DynamiceBNCompoundVector vectorNatural = this.createEmtpyCompoundVector();
        globalMomentsParam.getVectorTime0().divideBy(globalMomentsParam.getIndicatorTime0());
        globalMomentsParam.getVectorTimeT().divideBy(globalMomentsParam.getIndicatorTimeT());
        this.bayesianNetworkTime0.setMomentParameters((MomentParameters)globalMomentsParam.getVectorTime0());
        this.bayesianNetworkTimeT.setMomentParameters((MomentParameters)globalMomentsParam.getVectorTimeT());
        vectorNatural.setVectorTime0(this.bayesianNetworkTime0.getNaturalParameters());
        vectorNatural.setVectorTimeT(this.bayesianNetworkTimeT.getNaturalParameters());
        this.naturalParameters = vectorNatural;
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        DynamiceBNCompoundVector globalNaturalParam = (DynamiceBNCompoundVector)this.naturalParameters;
        DynamiceBNCompoundVector vectorMoments = this.createEmtpyCompoundVector();
        this.bayesianNetworkTime0.setNaturalParameters((NaturalParameters)globalNaturalParam.getVectorTime0());
        this.bayesianNetworkTimeT.setNaturalParameters((NaturalParameters)globalNaturalParam.getVectorTimeT());
        vectorMoments.setVectorTime0(this.bayesianNetworkTime0.getNaturalParameters());
        vectorMoments.setVectorTimeT(this.bayesianNetworkTimeT.getNaturalParameters());
        this.momentParameters = vectorMoments;
    }

    @Override
    public SufficientStatistics getSufficientStatistics(DynamicDataInstance data) {
        DynamiceBNCompoundVector vectorSS = this.createEmtpyCompoundVector();
        if (data.getTimeID() == 0L) {
            vectorSS.setIndicatorTime0(1.0);
            vectorSS.setVectorTime0(this.bayesianNetworkTime0.getSufficientStatistics(data));
        } else {
            vectorSS.setIndicatorTimeT(1.0);
            vectorSS.setVectorTimeT(this.bayesianNetworkTimeT.getSufficientStatistics(data));
        }
        return vectorSS;
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return this.bayesianNetworkTimeT.sizeOfSufficientStatistics() + this.bayesianNetworkTime0.sizeOfSufficientStatistics();
    }

    @Override
    public double computeLogBaseMeasure(DynamicDataInstance dataInstance) {
        throw new UnsupportedOperationException("No make sense for dynamic BNs");
    }

    @Override
    public double computeLogNormalizer() {
        throw new UnsupportedOperationException("No make sense for dynamic BNs");
    }

    @Override
    public double computeLogProbabilityOf(DynamicDataInstance dataInstance) {
        if (dataInstance.getTimeID() == 0L) {
            return this.bayesianNetworkTime0.computeLogProbabilityOf(dataInstance);
        }
        return this.bayesianNetworkTimeT.computeLogProbabilityOf(dataInstance);
    }

    @Override
    public Vector createZeroVector() {
        return this.createCompoundVector();
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        DynamiceBNCompoundVector vectorSS = this.createEmtpyCompoundVector();
        vectorSS.setIndicatorTime0(1.0);
        vectorSS.setVectorTime0(this.bayesianNetworkTime0.createInitSufficientStatistics());
        vectorSS.setIndicatorTimeT(1.0);
        vectorSS.setVectorTimeT(this.bayesianNetworkTimeT.createInitSufficientStatistics());
        return vectorSS;
    }

    public Vector createEmptyZeroedVector() {
        return this.createEmtpyCompoundVector();
    }

    private DynamiceBNCompoundVector createEmtpyCompoundVector() {
        return new DynamiceBNCompoundVector(this.bayesianNetworkTime0.sizeOfSufficientStatistics() + this.bayesianNetworkTimeT.sizeOfSufficientStatistics());
    }

    private DynamiceBNCompoundVector createCompoundVector() {
        return new DynamiceBNCompoundVector(this.bayesianNetworkTime0.createZeroVector(), this.bayesianNetworkTimeT.createZeroVector());
    }

    public EF_BayesianNetwork getBayesianNetworkTime0() {
        return this.bayesianNetworkTime0;
    }

    public EF_BayesianNetwork getBayesianNetworkTimeT() {
        return this.bayesianNetworkTimeT;
    }

    public DynamicBayesianNetwork toDynamicBayesianNetwork(DynamicDAG dag) {
        return new DynamicBayesianNetwork(dag, EF_BayesianNetwork.toConditionalDistribution(this.bayesianNetworkTime0.getDistributionList()), EF_BayesianNetwork.toConditionalDistribution(this.bayesianNetworkTimeT.getDistributionList()));
    }

    public static class DynamiceBNCompoundVector
    implements SufficientStatistics,
    MomentParameters,
    NaturalParameters {
        double indicatorTime0 = 0.0;
        double indicatorTimeT = 0.0;
        Vector vectorTime0;
        Vector vectorTimeT;
        int totalVectorSize;

        public DynamiceBNCompoundVector(int totalVectorSize1) {
            this.vectorTime0 = null;
            this.vectorTimeT = null;
            this.totalVectorSize = totalVectorSize1;
        }

        public DynamiceBNCompoundVector(Vector vectorTime0_1, Vector vectorTimeT_1) {
            this.vectorTime0 = vectorTime0_1;
            this.vectorTimeT = vectorTimeT_1;
            this.totalVectorSize = this.vectorTime0.size() + this.vectorTimeT.size();
        }

        public double getIndicatorTime0() {
            return this.indicatorTime0;
        }

        public void setIndicatorTime0(double indicatorTime0) {
            this.indicatorTime0 = indicatorTime0;
        }

        public double getIndicatorTimeT() {
            return this.indicatorTimeT;
        }

        public void setIndicatorTimeT(double indicatorTimeT) {
            this.indicatorTimeT = indicatorTimeT;
        }

        public Vector getVectorTime0() {
            return this.vectorTime0;
        }

        public void setVectorTime0(Vector vectorTime0) {
            this.vectorTime0 = vectorTime0;
        }

        public Vector getVectorTimeT() {
            return this.vectorTimeT;
        }

        public void setVectorTimeT(Vector vectorTimeT) {
            this.vectorTimeT = vectorTimeT;
        }

        @Override
        public double get(int i) {
            throw new UnsupportedOperationException("No get for this vector implementation");
        }

        @Override
        public void set(int i, double val) {
            throw new UnsupportedOperationException("No set for this vector implementation");
        }

        @Override
        public int size() {
            return this.totalVectorSize + 2;
        }

        @Override
        public void sum(Vector vector) {
            this.sum((DynamiceBNCompoundVector)vector);
        }

        @Override
        public void copy(Vector vector) {
            this.copy((DynamiceBNCompoundVector)vector);
        }

        @Override
        public void divideBy(double val) {
            this.indicatorTime0 /= val;
            if (this.vectorTime0 != null) {
                this.vectorTime0.divideBy(val);
            }
            this.indicatorTimeT /= val;
            if (this.vectorTimeT != null) {
                this.vectorTimeT.divideBy(val);
            }
        }

        @Override
        public double dotProduct(Vector vec) {
            return this.dotProduct((DynamiceBNCompoundVector)vec);
        }

        public double dotProduct(DynamiceBNCompoundVector vec) {
            if (vec.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size. ");
            }
            double sum = 0.0;
            sum += this.getIndicatorTime0() * vec.getIndicatorTime0();
            sum += this.getIndicatorTimeT() * vec.getIndicatorTimeT();
            if (this.vectorTime0 != null && vec.getVectorTime0() != null) {
                sum += this.vectorTime0.dotProduct(vec.getVectorTime0());
            }
            if (this.vectorTimeT != null && vec.getVectorTimeT() != null) {
                sum += this.vectorTimeT.dotProduct(vec.getVectorTimeT());
            }
            return sum;
        }

        public void copy(DynamiceBNCompoundVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size. ");
            }
            this.setIndicatorTime0(vector.getIndicatorTime0());
            this.setIndicatorTimeT(vector.getIndicatorTimeT());
            if (this.vectorTime0 == null) {
                this.vectorTime0 = vector.getVectorTime0();
            } else if (vector.getVectorTime0() == null) {
                this.vectorTime0 = null;
            } else {
                this.vectorTime0.copy(vector.getVectorTime0());
            }
            if (this.vectorTimeT == null) {
                this.vectorTimeT = vector.getVectorTimeT();
            } else if (vector.getVectorTimeT() == null) {
                this.vectorTimeT = null;
            } else {
                this.vectorTimeT.copy(vector.getVectorTimeT());
            }
        }

        public void sum(DynamiceBNCompoundVector vector) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Error in variable Vector. Method copy. The parameter vec has a different size. ");
            }
            this.setIndicatorTime0(this.getIndicatorTime0() + vector.getIndicatorTime0());
            this.setIndicatorTimeT(this.getIndicatorTimeT() + vector.getIndicatorTimeT());
            if (this.vectorTime0 == null) {
                this.vectorTime0 = vector.getVectorTime0();
            } else if (vector.getVectorTime0() != null) {
                this.vectorTime0.sum(vector.getVectorTime0());
            }
            if (this.vectorTimeT == null) {
                this.vectorTimeT = vector.getVectorTimeT();
            } else if (vector.getVectorTimeT() != null) {
                this.vectorTimeT.sum(vector.getVectorTimeT());
            }
        }
    }
}

