/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.learning.parametric.bayesian;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_LearningBayesianNetwork;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.inference.messagepassing.Node;
import eu.amidst.core.inference.messagepassing.VMP;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.models.DynamicDAG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PlateauStructure {
    List<Node> parametersNodeTime0;
    List<Node> parametersNodeTimeT;
    List<Node> nodesTime0;
    List<List<Node>> plateuNodesTimeT;
    List<Node> cloneNodesTimeT;
    DynamicDAG dbnModel;
    EF_LearningBayesianNetwork ef_learningmodelTimeT;
    EF_LearningBayesianNetwork ef_learningmodelTime0;
    int nRepetitions = 100;
    VMP vmpTime0 = new VMP();
    VMP vmpTimeT = new VMP();
    Map<Variable, Node> cloneVariablesToNode;
    Map<Variable, Node> parametersToNodeTimeT;
    Map<Variable, Node> parametersToNodeTime0;
    Map<Variable, Node> variablesToNodeTime0;
    List<Map<Variable, Node>> variablesToNodeTimeT;

    public void resetQs() {
        this.vmpTime0.resetQs();
        this.vmpTimeT.resetQs();
    }

    public void setDBNModel(DynamicDAG dbnModel) {
        this.dbnModel = dbnModel;
        List<EF_ConditionalDistribution> distTim0 = this.dbnModel.getParentSetsTime0().stream().map(pSet -> ((DistributionType)pSet.getMainVar().getDistributionType()).newEFConditionalDistribution(pSet.getParents())).collect(Collectors.toList());
        this.setEFBayesianNetworkTime0(new EF_LearningBayesianNetwork(distTim0));
        List<EF_ConditionalDistribution> distTimT = this.dbnModel.getParentSetsTimeT().stream().map(pSet -> ((DistributionType)pSet.getMainVar().getDistributionType()).newEFConditionalDistribution(pSet.getParents())).collect(Collectors.toList());
        this.setEFBayesianNetworkTimeT(new EF_LearningBayesianNetwork(distTimT));
    }

    public VMP getVMPTime0() {
        return this.vmpTime0;
    }

    public VMP getVMPTimeT() {
        return this.vmpTimeT;
    }

    public void setSeed(int seed) {
        this.vmpTime0.setSeed(seed);
        this.vmpTimeT.setSeed(seed);
    }

    public EF_LearningBayesianNetwork getEFLearningBNTimeT() {
        return this.ef_learningmodelTimeT;
    }

    public EF_LearningBayesianNetwork getEFLearningBNTime0() {
        return this.ef_learningmodelTime0;
    }

    public void setNRepetitions(int nRepetitions_) {
        this.nRepetitions = nRepetitions_;
    }

    public void runInferenceTimeT() {
        this.vmpTimeT.runInference();
        this.plateuNodesTimeT.get(this.nRepetitions - 1).stream().filter(node -> !node.isObserved() && !node.getMainVariable().isParameterVariable()).forEach(node -> {
            Variable temporalClone = this.dbnModel.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
            PlateauStructure.moveNodeQDist(this.getNodeOfVarTimeT(temporalClone, 0), node);
        });
    }

    public void runInferenceTime0() {
        this.vmpTime0.runInference();
        this.vmpTime0.getNodes().stream().filter(node -> !node.isObserved() && !node.getMainVariable().isParameterVariable()).forEach(node -> {
            Variable temporalClone = this.dbnModel.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
            PlateauStructure.moveNodeQDist(this.getNodeOfVarTimeT(temporalClone, 0), node);
        });
    }

    private static void moveNodeQDist(Node toTemporalCloneNode, Node fromNode) {
        EF_UnivariateDistribution uni = fromNode.getQDist().deepCopy(toTemporalCloneNode.getMainVariable());
        toTemporalCloneNode.setPDist(uni);
        toTemporalCloneNode.setQDist(uni);
    }

    public double getLogProbabilityOfEvidenceTimeT() {
        return this.vmpTimeT.getLogProbabilityOfEvidence();
    }

    public double getLogProbabilityOfEvidenceTime0() {
        return this.vmpTime0.getLogProbabilityOfEvidence();
    }

    private void setEFBayesianNetworkTime0(EF_LearningBayesianNetwork modelTime0) {
        this.ef_learningmodelTime0 = modelTime0;
        this.parametersNodeTime0 = new ArrayList<Node>();
        this.parametersToNodeTime0 = new ConcurrentHashMap<Variable, Node>();
        this.parametersNodeTime0 = this.ef_learningmodelTime0.getDistributionList().stream().filter(dist -> dist.getVariable().isParameterVariable()).map(dist -> {
            Node node = new Node((EF_ConditionalDistribution)dist);
            this.parametersToNodeTime0.put(dist.getVariable(), node);
            return node;
        }).collect(Collectors.toList());
        this.variablesToNodeTime0 = new ConcurrentHashMap<Variable, Node>();
        this.nodesTime0 = this.ef_learningmodelTime0.getDistributionList().stream().filter(dist -> !dist.getVariable().isParameterVariable()).map(dist -> {
            Node node = new Node((EF_ConditionalDistribution)dist);
            this.variablesToNodeTime0.put(dist.getVariable(), node);
            return node;
        }).collect(Collectors.toList());
        for (Node node : this.nodesTime0) {
            node.setParents(node.getPDist().getConditioningVariables().stream().map(var -> this.getNodeOfVarTime0((Variable)var)).collect(Collectors.toList()));
            node.getPDist().getConditioningVariables().stream().forEach(var -> this.getNodeOfVarTime0((Variable)var).getChildren().add(node));
        }
        ArrayList<Node> allNodesTime0 = new ArrayList<Node>();
        allNodesTime0.addAll(this.parametersNodeTime0);
        allNodesTime0.addAll(this.nodesTime0);
        this.vmpTime0.setNodes(allNodesTime0);
    }

    private void setEFBayesianNetworkTimeT(EF_LearningBayesianNetwork modelTimeT) {
        this.ef_learningmodelTimeT = modelTimeT;
        this.parametersNodeTimeT = new ArrayList<Node>();
        this.plateuNodesTimeT = new ArrayList<List<Node>>(this.nRepetitions);
        this.cloneNodesTimeT = new ArrayList<Node>();
        this.variablesToNodeTimeT = new ArrayList<Map<Variable, Node>>();
        this.parametersToNodeTimeT = new ConcurrentHashMap<Variable, Node>();
        this.parametersNodeTimeT = this.ef_learningmodelTimeT.getDistributionList().stream().filter(dist -> dist.getVariable().isParameterVariable()).map(dist -> {
            Node node = new Node((EF_ConditionalDistribution)dist);
            this.parametersToNodeTimeT.put(dist.getVariable(), node);
            return node;
        }).collect(Collectors.toList());
        this.cloneVariablesToNode = new ConcurrentHashMap<Variable, Node>();
        this.cloneNodesTimeT = this.ef_learningmodelTimeT.getDistributionList().stream().filter(dist -> !dist.getVariable().isParameterVariable()).map(dist -> {
            Variable temporalClone = this.dbnModel.getDynamicVariables().getInterfaceVariable(dist.getVariable());
            Object uni = ((UnivariateDistribution)((DistributionType)temporalClone.getDistributionType()).newUnivariateDistribution()).toEFUnivariateDistribution();
            Node node = new Node((EF_ConditionalDistribution)uni);
            node.setActive(false);
            this.cloneVariablesToNode.put(temporalClone, node);
            return node;
        }).collect(Collectors.toList());
        int i = 0;
        while (i < this.nRepetitions) {
            int slice = i++;
            ConcurrentHashMap map = new ConcurrentHashMap();
            List tmpNodes = this.ef_learningmodelTimeT.getDistributionList().stream().filter(dist -> !dist.getVariable().isParameterVariable()).map(dist -> {
                Node node = new Node((EF_ConditionalDistribution)dist, dist.getVariable().getName() + "_Slice_" + slice);
                map.put(dist.getVariable(), node);
                return node;
            }).collect(Collectors.toList());
            this.variablesToNodeTimeT.add(map);
            this.plateuNodesTimeT.add(tmpNodes);
        }
        for (i = 0; i < this.nRepetitions; ++i) {
            for (Node node : this.plateuNodesTimeT.get(i)) {
                int slice = i;
                node.setParents(node.getPDist().getConditioningVariables().stream().map(var -> this.getNodeOfVarTimeT((Variable)var, slice)).collect(Collectors.toList()));
                node.getPDist().getConditioningVariables().stream().filter(var -> var.isInterfaceVariable()).forEach(var -> node.setVariableToNodeParent((Variable)var, this.getNodeOfVarTimeT((Variable)var, slice)));
                node.getPDist().getConditioningVariables().stream().forEach(var -> this.getNodeOfVarTimeT((Variable)var, slice).getChildren().add(node));
            }
        }
        ArrayList<Node> allNodesTimeT = new ArrayList<Node>();
        allNodesTimeT.addAll(this.parametersNodeTimeT);
        for (int i2 = 0; i2 < this.nRepetitions; ++i2) {
            allNodesTimeT.addAll((Collection<Node>)this.plateuNodesTimeT.get(i2));
        }
        this.vmpTimeT.setNodes(allNodesTimeT);
    }

    public void setEvidenceTime0(DynamicDataInstance data) {
        this.vmpTime0.setEvidence(data);
    }

    public void setEvidenceTimeT(List<DynamicDataInstance> data) {
        int i;
        if (data.size() > this.nRepetitions) {
            throw new IllegalArgumentException("The size of the data is bigger than the number of repetitions");
        }
        this.cloneNodesTimeT.forEach(node -> node.setAssignment((Assignment)data.get(0)));
        for (i = 0; i < this.nRepetitions && i < data.size(); ++i) {
            int slice = i;
            this.plateuNodesTimeT.get(i).forEach(node -> {
                node.setAssignment((Assignment)data.get(slice));
                node.setActive(true);
                if (!node.isObserved() && node.getChildren().isEmpty()) {
                    node.setActive(false);
                }
            });
        }
        for (i = data.size(); i < this.nRepetitions; ++i) {
            this.plateuNodesTimeT.get(i).forEach(node -> {
                node.setAssignment(null);
                node.setActive(false);
            });
        }
    }

    public Node getNodeOfVarTime0(Variable variable) {
        if (variable.isParameterVariable()) {
            return this.parametersToNodeTime0.get(variable);
        }
        return this.variablesToNodeTime0.get(variable);
    }

    public Node getNodeOfVarTimeT(Variable variable, int slice) {
        if (variable.isParameterVariable()) {
            return this.parametersToNodeTimeT.get(variable);
        }
        if (!variable.isInterfaceVariable()) {
            return this.variablesToNodeTimeT.get(slice).get(variable);
        }
        if (variable.isInterfaceVariable() && slice > 0) {
            return this.variablesToNodeTimeT.get(slice - 1).get(this.dbnModel.getDynamicVariables().getVariableFromInterface(variable));
        }
        if (variable.isInterfaceVariable() && slice == 0) {
            return this.cloneVariablesToNode.get(variable);
        }
        throw new IllegalArgumentException();
    }

    public <E extends EF_UnivariateDistribution> E getEFParameterPosteriorTimeT(Variable var) {
        if (!var.isParameterVariable()) {
            throw new IllegalArgumentException("Only parameter variables can be queried");
        }
        return (E)this.parametersToNodeTimeT.get(var).getQDist();
    }

    public <E extends EF_UnivariateDistribution> E getEFParameterPosteriorTime0(Variable var) {
        if (!var.isParameterVariable()) {
            throw new IllegalArgumentException("Only parameter variables can be queried");
        }
        return (E)this.parametersToNodeTime0.get(var).getQDist();
    }
}

