/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.utils;

import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.models.DynamicDAG;
import eu.amidst.dynamic.variables.DynamicVariables;
import java.util.ArrayList;
import java.util.List;

public final class Utils {
    public static List<Variable> getCausalOrderTime0(DynamicDAG dag) {
        DynamicVariables variables = dag.getDynamicVariables();
        int nNrOfAtts = variables.getNumberOfVars();
        ArrayList<Variable> order = new ArrayList<Variable>();
        boolean[] bDone = new boolean[variables.getNumberOfVars()];
        for (Variable var : variables) {
            bDone[var.getVarID()] = false;
        }
        for (int iAtt = 0; iAtt < nNrOfAtts; ++iAtt) {
            boolean allParentsDone = false;
            for (Variable var2 : variables) {
                if (bDone[var2.getVarID()]) continue;
                allParentsDone = true;
                boolean iParent = false;
                for (Variable parent : dag.getParentSetTime0(var2)) {
                    allParentsDone = allParentsDone && bDone[parent.getVarID()];
                }
                if (!allParentsDone) continue;
                order.add(var2);
                bDone[var2.getVarID()] = true;
            }
        }
        return order;
    }

    public static List<Variable> getCausalOrderTimeT(DynamicDAG dag) {
        DynamicVariables variables = dag.getDynamicVariables();
        int nNrOfAtts = variables.getNumberOfVars();
        ArrayList<Variable> order = new ArrayList<Variable>();
        boolean[] bDone = new boolean[variables.getNumberOfVars()];
        for (Variable var : variables) {
            bDone[var.getVarID()] = false;
        }
        for (int iAtt = 0; iAtt < nNrOfAtts; ++iAtt) {
            boolean allParentsDone = false;
            for (Variable var2 : variables) {
                if (bDone[var2.getVarID()]) continue;
                allParentsDone = true;
                for (Variable parent : dag.getParentSetTimeT(var2)) {
                    if (parent.isInterfaceVariable()) continue;
                    allParentsDone = allParentsDone && bDone[parent.getVarID()];
                }
                if (!allParentsDone) continue;
                order.add(var2);
                bDone[var2.getVarID()] = true;
            }
        }
        return order;
    }
}

