% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imbalance.R
\name{imbal}
\alias{imbal}
\title{Representing the allocation imbalance}
\usage{
imbal(type)
}
\arguments{
\item{type}{character string, should be one of \code{"imb"}, \code{"absImb"}, 
\code{"loss"}, or \code{"maxImb"}, see Details.}
}
\value{
\code{S4} object of class \code{imbal}, a formal representation of the issue of
imbalance in a clinical trial.
}
\description{
Represents the imbalance of the treatment assignments 
of patients in a clinical trial.
}
\details{
Balance of the treatment assignment of patients can
be an issue in the design of a clinical trial. The \code{imbal} function is
a constructor function for an S4 object of class \code{imbal} representing
the issue of imbalance of a clinical trial. The parameter \code{type} can 
take the following values: 
The \code{type}
\describe{
  \item{\code{"imb"}}{the final imbalance, i.e. difference in group sizes at the end of a trial}
  \item{\code{"absImb"}}{the absolute value of the final imbalance}
 \item{\code{"loss"}}{the loss in power estimation, i.e. \code{imb^2/N}}
  \item{\code{"maxImb"}}{the maximal attained imbalance during the trial}
}
}
\references{
A.C. Atkinson (2014) Selecting a biased coin design. \emph{Statistical Science}, \strong{29}, Vol. 1, 144-163.
}
\seealso{
Other issues: 
\code{\link{chronBias}},
\code{\link{combineBias}()},
\code{\link{corGuess}},
\code{\link{issue}},
\code{\link{selBias}},
\code{\link{setPower}()}
}
\concept{issues}
