% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbrPar.R
\name{pbrPar}
\alias{pbrPar}
\title{Representing Permuted Block Randomization}
\usage{
pbrPar(bc, K = 2, ratio = rep(1, K), groups = LETTERS[1:K])
}
\arguments{
\item{bc}{vector which contains the lengths \code{k_1,...,k_l} of each block.
This means that the vector \code{bc} will have one entry for each block.}

\item{K}{number of treatment groups (e.g. K=2 if we compare one experimental
against one control treatment).}

\item{ratio}{vector of length \code{K}. The total sample number \code{N} and
all used block lengths (\code{bc}) have to be divisible by \code{sum(ratio)}.}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{pbrPar}.
}
\description{
Represents the randomization procedure Permuted Block Randomization.
}
\details{
Fix the block constellation \code{bc}, the number of treatment groups \code{K},
and the vector of the \code{ratio}. Afterwards,
in each block the patients are assigned according to the ratio to the 
corresponding treatment groups. All generated randomization sequences
are equiprobable.
}
\references{
W. F. Rosenberger and J. M. Lachin (2002) \emph{Randomization in Clinical Trials}.
Wiley.
}
\seealso{
Other randomization procedures: 
\code{\link{abcdPar}},
\code{\link{bbcdPar}},
\code{\link{bsdPar}},
\code{\link{chenPar}},
\code{\link{crPar}},
\code{\link{createParam}()},
\code{\link{ebcPar}},
\code{\link{gbcdPar}},
\code{\link{hadaPar}},
\code{\link{mpPar}},
\code{\link{rarPar}},
\code{\link{rpbrPar}},
\code{\link{rtbdPar}},
\code{\link{tbdPar}},
\code{\link{udPar}}
}
\concept{randomization procedures}
