## generated by rang, do not edit by hand

.install_packages <- function(tarball_path, lib, verbose, current_r_version) {
    if (utils::compareVersion(current_r_version, "3.0") != -1) {
        if (is.na(lib)) {
            install.packages(pkg = tarball_path, repos = NULL, verbose = verbose, quiet = !verbose)
        } else {
            install.packages(pkg = tarball_path, lib = lib, repos = NULL, verbose = verbose, quiet = !verbose)
        }
    } else {
        if (is.na(lib)) {
            install.packages(pkg = tarball_path, repos = NULL)
        } else {
            install.packages(pkg = tarball_path, lib = lib, repos = NULL)
        }
    }
}

.download_package <- function(tarball_path, x, version, handle, source, uid, verbose) {
    if (source == "github") {
        .download_package_from_github(tarball_path, x, version, handle, source, uid)
    } else {
        url <- paste(cran_mirror, "src/contrib/Archive/", x, "/", x, "_", version, ".tar.gz", sep = "")
        tryCatch({
            suppressWarnings(download.file(url, destfile = tarball_path, quiet = !verbose))
        }, error = function(e) {
            ## is the current latest
            url <- paste(cran_mirror, "src/contrib/", x, "_", version, ".tar.gz", sep = "")
            download.file(url, destfile = tarball_path, quiet = !verbose)
        })
    }
    invisible(tarball_path)
}

.tempfile <- function(tmpdir = tempdir(), fileext = ".tar.gz") {
    file.path(tmpdir,
    paste(paste(sample(c(LETTERS, letters), 20, replace = TRUE), collapse = "")),
    fileext)
}

.build_raw_tarball <- function(raw_tarball_path, x, version, tarball_path) {
    tmp_dir <- .tempfile(fileext = "")
    dir.create(tmp_dir)
    system(command = paste("tar", "-zxf ", raw_tarball_path, "-C", tmp_dir))
    pkg_dir <- list.files(path = tmp_dir, full.names = TRUE)[1]
    new_pkg_dir <- file.path(tmp_dir, x)
    file.rename(pkg_dir, new_pkg_dir)
    res <- system(command = paste("R", "CMD", "build", new_pkg_dir))
    expected_tarball_path <- paste(x, "_", version, ".tar.gz", sep = "")
    stopifnot(file.exists(expected_tarball_path))
    file.rename(expected_tarball_path, tarball_path)
    return(tarball_path)
}

.install_from_source <- function(x, version, handle, source, uid, lib,
                                 path = tempdir(), verbose, cran_mirror, current_r_version) {
    tarball_path <- file.path(path, paste(x, "_", version, ".tar.gz", sep = ""))
    raw_tarball_path <- file.path(path, paste("raw_", x, "_", version, ".tar.gz", sep = ""))
    if (!file.exists(tarball_path) && !file.exists(raw_tarball_path)) {
        .download_package(tarball_path = tarball_path, x = x, version = version, handle = handle, source = source,
                          uid = uid, verbose = verbose)
    }
    if (file.exists(raw_tarball_path)) {
        tarball_path <- .build_raw_tarball(raw_tarball_path, x = x, version = version, tarball_path)
        if (!file.exists(tarball_path)) {
            stop("building failed.")
        }
    }
    .install_packages(tarball_path, lib, verbose, current_r_version)
    ## check and error
    if (!is.na(lib)) {
        installed_packages <- installed.packages(lib.loc = lib)
    } else {
        installed_packages <- installed.packages()
    }
    if (!x %in% dimnames(installed_packages)[[1]]) {
        stop("Fail to install ", x, "\n")
    }
    invisible()
}

# installing github packages
.download_github_safe <- function(handle, sha, file) {
    tryCatch(
        download.file(paste("http://api.github.com/repos/", handle, "/tarball/", sha, sep = ""), destfile = file),
        error = function(e) {
            stop(paste("couldn't download ", handle, " from github", sep = ""), call. = FALSE)
        }
    )
}

.tempfile <- function(tmpdir = tempdir(), fileext = ".tar.gz") {
    file.path(tmpdir,
    paste(paste(sample(c(LETTERS, letters), 20, replace = TRUE), collapse = ""), fileext, sep = ""))
}

.download_package_from_github <- function(tarball_path, x, version, handle, source, uid) {
    sha <- uid
    short_sha <- substr(sha, 1, 7)
    dest_tar <- .tempfile(fileext = ".tar.gz")
    tmp_dir <- tempdir()
    tryCatch(
        download.file(paste("https://api.github.com/repos/", handle, "/tarball/", sha, sep = ""), destfile = dest_tar),
        error = function(e) {
            .download_github_safe(handle, sha, dest_tar)
        }
    )  
    system(command = paste("tar", "-zxf ", dest_tar, "-C", tmp_dir))
    dlist <- list.dirs(path = tmp_dir, recursive = FALSE) ## TODO list.dirs is 2.14
    pkg_dir <- dlist[grepl(short_sha, dlist)] ## TODO grepl is 2.9.0
    if(length(pkg_dir) != 1) {
        stop(paste("couldn't uniquely locate the unzipped package source in ",tmp_dir, sep = ""))
    }
    res <- system(command = paste("R", "CMD", "build", pkg_dir), intern = TRUE)
    expected_tarball_path <- paste(x, "_", version, ".tar.gz", sep = "")
    if (!file.exists(expected_tarball_path)) {
        stop("Cannot locate the built tarball.")
    }
    file.rename(from = expected_tarball_path, to = tarball_path)
    return(tarball_path)
}
