% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmb.R
\name{rmb}
\alias{rmb}
\title{Random Mallows-Binomial generation.}
\usage{
rmb(I, p, pi0 = NULL, theta, M, R = length(p))
}
\arguments{
\item{I}{Numeric indicating the number of observations to be drawn.}

\item{p}{Vector specifying the underlying object qualities.}

\item{pi0}{Vector specifying the consensus (modal probability) ranking; should be used only for tie-breaking equal values in p.}

\item{theta}{Numeric specifying the Mallows scale parameter.}

\item{M}{Numeric specifying the maximum integer rating.}

\item{R}{Numeric specifying the length of the (partial) rankings to be drawn.}
}
\value{
List containing elements X (I x J matrix of ratings) and Pi (I x R matrix of rankings).
}
\description{
This function randomly generates rankings and ratings from a Mallows-Binomial distribution.
}
\examples{
rmb(I=5,p=c(.1,.3,.4,.7,.9),theta=1,M=10)
rmb(I=10,p=c(.1,.3,.3,.7,.9),pi0=c(1,3,2,4,5),theta=5,M=40,R=3)
 
}
