% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapidrake.R
\name{rapidrake}
\alias{rapidrake}
\title{Rapid RAKE}
\usage{
rapidrake(txt, stop_words = slowraker::smart_words, stop_pos = c("VB",
  "VBD", "VBG", "VBN", "VBP", "VBZ"), word_min_char = 3, stem = TRUE,
  phrase_delims = "[-,.?():;\\"!/]")
}
\arguments{
\item{txt}{A character vector, where each element of the vector contains the
text for one document.}

\item{stop_words}{A vector of stop words which will be removed from your
documents. The default value (\code{smart_words}) contains the 'SMART' stop
words (equivalent to
\href{https://rdrr.io/rforge/tm/man/stopwords.html}{tm::stopwords('SMART')})
. Set \code{stop_words = NULL} if you don't want to remove stop words.}

\item{stop_pos}{All words that have a part-of-speech (POS) that appears in
\code{stop_pos} will be considered a stop word. \code{stop_pos} should be a
vector of POS tags. All possible POS tags along with their definitions are
in the \code{\link{pos_tags}} data frame (\code{View(slowraker::pos_tags)}).
The default value is to remove all words that have a verb-based
POS (i.e., \code{stop_pos = c("VB", "VBD", "VBG", "VBN", "VBP", "VBZ")}).
Set \code{stop_pos = NULL} if you don't want a word's POS to matter during
keyword extraction.}

\item{word_min_char}{The minimum number of characters that a word must have
to remain in the corpus. Words with fewer than \code{word_min_char}
characters will be removed before the RAKE algorithm is applied. Note
that removing words based on \code{word_min_char} happens before stemming,
so you should consider the full length of the word and not the length of
its stem when choosing \code{word_min_char}.}

\item{stem}{Do you want to stem the words before running RAKE?}

\item{phrase_delims}{A regular expression containing the characters that
will be used as phrase delimiters}
}
\description{
A relatively fast version of the Rapid Automatic Keyword Extraction (RAKE)
algorithm. See \href{http://media.wiley.com/product_data/excerpt/22/04707498/0470749822.pdf}{
Automatic keyword extraction from individual documents} for details on how
RAKE works.
}
\examples{
rapidrake(txt = "some text that has great keywords")
}
