#' @title Supplemental color maps for rasterly
#' @name color_map
#' @description Hex codes for the color map.
#' Used in setting argument \code{color} in \code{rasterly} or \code{rasterly} layers.
#' @format An object of class \code{character} of length 256.
#' @export
fire_map <-
  c('#000000',
    '#060000',
    '#0d0000',
    '#120000',
    '#160000',
    '#190000',
    '#1c0000',
    '#1f0000',
    '#220000',
    '#240000',
    '#260000',
    '#280000',
    '#2b0000',
    '#2d0000',
    '#2e0000',
    '#300000',
    '#320000',
    '#340000',
    '#350000',
    '#370000',
    '#380000',
    '#3a0000',
    '#3b0000',
    '#3d0000',
    '#3e0000',
    '#400000',
    '#410000',
    '#430000',
    '#440000',
    '#460000',
    '#470000',
    '#490000',
    '#4a0000',
    '#4c0000',
    '#4d0000',
    '#4f0000',
    '#500000',
    '#520000',
    '#530000',
    '#550000',
    '#560000',
    '#580000',
    '#590100',
    '#5b0100',
    '#5d0100',
    '#5e0100',
    '#600100',
    '#610100',
    '#630100',
    '#650100',
    '#660100',
    '#680100',
    '#690100',
    '#6b0100',
    '#6d0100',
    '#6e0100',
    '#700100',
    '#710100',
    '#730100',
    '#750100',
    '#760100',
    '#780200',
    '#7a0200',
    '#7b0200',
    '#7d0200',
    '#7f0200',
    '#800200',
    '#820200',
    '#840200',
    '#850200',
    '#870200',
    '#890200',
    '#8a0200',
    '#8c0300',
    '#8e0300',
    '#900300',
    '#910300',
    '#930300',
    '#950300',
    '#960300',
    '#980300',
    '#9a0300',
    '#9c0300',
    '#9d0400',
    '#9f0400',
    '#a10400',
    '#a20400',
    '#a40400',
    '#a60400',
    '#a80400',
    '#a90400',
    '#ab0500',
    '#ad0500',
    '#af0500',
    '#b00500',
    '#b20500',
    '#b40500',
    '#b60600',
    '#b80600',
    '#b90600',
    '#bb0600',
    '#bd0600',
    '#bf0700',
    '#c00700',
    '#c20700',
    '#c40700',
    '#c60800',
    '#c80800',
    '#c90800',
    '#cb0800',
    '#cd0900',
    '#cf0900',
    '#d10900',
    '#d20a00',
    '#d40a00',
    '#d60a00',
    '#d80b00',
    '#da0b00',
    '#db0c00',
    '#dd0c00',
    '#df0d00',
    '#e10d00',
    '#e30e00',
    '#e40f00',
    '#e60f00',
    '#e81000',
    '#ea1100',
    '#eb1300',
    '#ed1400',
    '#ee1600',
    '#f01800',
    '#f11b00',
    '#f21d00',
    '#f32000',
    '#f52300',
    '#f62600',
    '#f62900',
    '#f72c00',
    '#f82f00',
    '#f93200',
    '#f93500',
    '#fa3800',
    '#fa3b00',
    '#fb3d00',
    '#fb4000',
    '#fb4300',
    '#fc4600',
    '#fc4900',
    '#fc4b00',
    '#fd4e00',
    '#fd5100',
    '#fd5300',
    '#fd5600',
    '#fd5800',
    '#fe5b00',
    '#fe5d00',
    '#fe5f00',
    '#fe6200',
    '#fe6400',
    '#fe6600',
    '#fe6800',
    '#fe6b00',
    '#fe6d00',
    '#fe6f00',
    '#fe7100',
    '#fe7300',
    '#fe7500',
    '#fe7700',
    '#fe7900',
    '#fe7c00',
    '#ff7e00',
    '#ff8000',
    '#ff8200',
    '#ff8300',
    '#ff8500',
    '#ff8700',
    '#ff8900',
    '#ff8b00',
    '#ff8d00',
    '#ff8f00',
    '#ff9100',
    '#ff9300',
    '#ff9400',
    '#ff9600',
    '#ff9800',
    '#ff9a00',
    '#ff9c00',
    '#ff9d00',
    '#ff9f00',
    '#ffa100',
    '#ffa300',
    '#ffa401',
    '#ffa601',
    '#ffa801',
    '#ffaa01',
    '#ffab01',
    '#ffad01',
    '#ffaf01',
    '#ffb001',
    '#ffb202',
    '#ffb402',
    '#ffb502',
    '#ffb702',
    '#ffb902',
    '#ffba02',
    '#ffbc03',
    '#ffbd03',
    '#ffbf03',
    '#ffc103',
    '#ffc204',
    '#ffc404',
    '#ffc604',
    '#ffc704',
    '#ffc905',
    '#ffca05',
    '#ffcc05',
    '#ffce06',
    '#ffcf06',
    '#ffd106',
    '#ffd207',
    '#ffd407',
    '#ffd508',
    '#ffd708',
    '#ffd909',
    '#ffda09',
    '#ffdc0a',
    '#ffdd0a',
    '#ffdf0b',
    '#ffe00b',
    '#ffe20c',
    '#ffe30d',
    '#ffe50e',
    '#ffe60f',
    '#ffe810',
    '#ffea11',
    '#ffeb12',
    '#ffed14',
    '#ffee17',
    '#fff01a',
    '#fff11e',
    '#fff324',
    '#fff42a',
    '#fff532',
    '#fff73b',
    '#fff847',
    '#fff953',
    '#fffb62',
    '#fffb72',
    '#fffc83',
    '#fffd95',
    '#fffea8',
    '#fffeba',
    '#fffecc',
    '#fffede',
    '#fffeee',
    '#ffffff')

#' @rdname color_map
#' @export
viridis_map <- c("#440154","#440255","#450357","#450558","#45065A","#46085B","#46095D","#460B5E","#460C60","#470E61","#470F62","#471164"
             ,"#471265","#471466","#481568","#481669","#48186A","#48196C","#481A6D","#481C6E","#481D6F","#481E70","#482071","#482173"
             ,"#482274","#482475","#482576","#482677","#482778","#472979","#472A79","#472B7A","#472C7B","#472E7C","#462F7D","#46307E"
             ,"#46317E","#46337F","#453480","#453581","#453681","#443882","#443983","#443A83","#433B84","#433C84","#433E85","#423F85"
             ,"#424086","#414186","#414287","#414387","#404588","#404688","#3F4788","#3F4889","#3E4989","#3E4A89","#3D4B8A","#3D4D8A"
             ,"#3C4E8A","#3C4F8A","#3B508B","#3B518B","#3A528B","#3A538B","#39548C","#39558C","#38568C","#38578C","#37588C","#37598C"
             ,"#365B8D","#365C8D","#355D8D","#355E8D","#345F8D","#34608D","#33618D","#33628D","#33638D","#32648E","#32658E","#31668E"
             ,"#31678E","#30688E","#30698E","#2F6A8E","#2F6B8E","#2F6C8E","#2E6D8E","#2E6E8E","#2D6F8E","#2D708E","#2D708E","#2C718E"
             ,"#2C728E","#2B738E","#2B748E","#2B758E","#2A768E","#2A778E","#29788E","#29798E","#297A8E","#287B8E","#287C8E","#287D8E"
             ,"#277E8E","#277F8E","#26808E","#26818E","#26828E","#25838E","#25838E","#25848E","#24858E","#24868E","#23878E","#23888E"
             ,"#23898E","#228A8D","#228B8D","#228C8D","#218D8D","#218E8D","#218F8D","#20908D","#20918C","#20928C","#20938C","#1F938C"
             ,"#1F948C","#1F958B","#1F968B","#1F978B","#1E988B","#1E998A","#1E9A8A","#1E9B8A","#1E9C89","#1E9D89","#1E9E89","#1E9F88"
             ,"#1EA088","#1FA188","#1FA287","#1FA387","#1FA386","#20A486","#20A586","#21A685","#21A785","#22A884","#23A983","#23AA83"
             ,"#24AB82","#25AC82","#26AD81","#27AE81","#28AF80","#29AF7F","#2AB07F","#2BB17E","#2CB27D","#2EB37C","#2FB47C","#30B57B"
             ,"#32B67A","#33B779","#35B779","#36B878","#38B977","#39BA76","#3BBB75","#3DBC74","#3EBD73","#40BE72","#42BE71","#44BF70"
             ,"#46C06F","#48C16E","#49C26D","#4BC26C","#4DC36B","#4FC46A","#51C569","#53C668","#55C666","#58C765","#5AC864","#5CC963"
             ,"#5EC962","#60CA60","#62CB5F","#65CC5E","#67CC5C","#69CD5B","#6CCE5A","#6ECE58","#70CF57","#73D055","#75D054","#77D152"
             ,"#7AD251","#7CD24F","#7FD34E","#81D44C","#84D44B","#86D549","#89D548","#8BD646","#8ED744","#90D743","#93D841","#95D83F"
             ,"#98D93E","#9BD93C","#9DDA3A","#A0DA39","#A3DB37","#A5DB35","#A8DC33","#ABDC32","#ADDD30","#B0DD2E","#B3DD2D","#B5DE2B"
             ,"#B8DE29","#BBDF27","#BDDF26","#C0DF24","#C3E023","#C5E021","#C8E120","#CBE11E","#CDE11D","#D0E21C","#D3E21B","#D5E21A"
             ,"#D8E319","#DBE318","#DDE318","#E0E418","#E2E418","#E5E418","#E8E519","#EAE519","#EDE51A","#EFE61B","#F2E61C","#F4E61E"
             ,"#F7E61F","#F9E721","#FBE723","#FEE724")

#' @rdname color_map
#' @export
hourColors_map <- c("#FF0000","#FF3F00","#FF7F00","#FFBF00","#FFFF00","#BFFF00","#7FFF00","#3FFF00",
                 "#00FF00","#00FF3F","#00FF7F","#00FFBF","#00FFFF","#00BFFF","#007FFF","#003FFF",
                 "#0000FF","#3F00FF","#7F00FF","#BF00FF","#FF00FF","#FF00BF","#FF007F","#FF003F")
