% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePosterior.R
\name{mergePosterior}
\alias{mergePosterior}
\title{Merge posterior distributions}
\usage{
mergePosterior(...)
}
\arguments{
\item{...}{any number of posterior distributions as produced by the function 'readMCMC'.}
}
\value{
A merged posterior distribution in the same format.
}
\description{
Join two or more independent MCMC chains from the same data and phylogenetic trees by appending them together into a single chain.
}
\examples{
\donttest{
data( centrarchidae )
## Set the limits of the uniform prior on the root based on the observed traits
data.range <- t( apply( centrarchidae$data, 2, range ) )
## The step size for the root value can be set given the range we need to sample from:
w_mu <- ( data.range[,2] - data.range[,1] ) / 10
## Set a reasonable value for the uniform prior distribution for the standard deviation.
## Here the minimum rate for the traits is 0 and the maximum is 10 ( using 'sqrt(10)' to 
##      transform to standard deviation).
par.sd <- cbind(c(0,0), sqrt( c(10,10) ))
## The proposal step on the standard deviation is a multiplier. So 0.2 is good enough 
##       for most cases.
w_sd <- matrix(0.2, ncol = 2, nrow = 2)
prior <- makePrior(r = 2, p = 2, den.mu = "unif", par.mu = data.range, den.sd = "unif"
                   , par.sd = par.sd)
## Run multiple MCMC chains.
handle.list <- lapply(1:4, function(x) ratematrixMCMC(data=centrarchidae$data
                      , phy=centrarchidae$phy.map, prior=prior, gen=10000
                      , w_mu=w_mu, w_sd=w_sd, dir=tempdir()) )
## Read all to a list
posterior.list <- lapply(handle.list, readMCMC)
## Merge all posteriors in the list.
merged.four <- mergePosterior(posterior.list)
## Merge some of the posteriors.
merged.two <- mergePosterior(posterior.list[[1]], posterior.list[[3]])
}
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
