% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{safe_write_csv}
\alias{safe_write_csv}
\title{Save data to comma separated value files with backups}
\usage{
safe_write_csv(x, file, ..., quiet = FALSE)
}
\arguments{
\item{x, file, ...}{pass to \code{write.csv}}

\item{quiet}{whether to suppress overwrite message}
}
\value{
Normalized path of \code{file}
}
\description{
Save comma separated value files, if file exists,
backup original file.
}
\examples{

f <- tempfile()
x <- data.frame(a = 1:10)

# File not exists, same as write file, returns normalized `f`
safe_write_csv(x, f)

# Check whether file exists
file.exists(f)

# write again, and the old file will be copied
safe_write_csv(x, f)

}
